<?php

class Dvents_Contact_Info_footer_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Contact_Info_footer_Widget',
			__( 'Contact info footer', 'ova-dvents' ),
			array( 'description' => __( 'Show contact info footer', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$html.= '<div class="footer__contact"><i class="icon '.$instance['icon'].'"></i> '.$instance['info_value'].'</div>';
		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$icon = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
		$info_value = ! empty( $instance['info_value'] ) ? $instance['info_value'] : '';
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>">
				<?php echo __( 'Icon:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'icon' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'icon' ) ); ?>"
                    type="text"
                    value="<?php echo __( $icon ); ?>"
            >
            <p> <?php echo __( "For example: icon-puzzle. Find here: http://simplelineicons.com/", 'ova-dvents' ) ?> </p>

        </p>




        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'info_value' ) ); ?>">
				<?php echo  __( 'Info value:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'info_value' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'info_value' ) ); ?>"
                    type="text"
                    value="<?php echo __( $info_value ); ?>"
            >
        </p>

		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['icon'] = ( ! empty( $new_instance['icon'] ) ) ? strip_tags( $new_instance['icon'] ) : '';
		$instance['info_value'] = ( ! empty( $new_instance['info_value'] ) ) ? strip_tags( $new_instance['info_value'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Contact_Info_footer_Widget() {
	register_widget( 'Dvents_Contact_Info_footer_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Contact_Info_footer_Widget' );