<?php

class Dvents_Call_Us_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Call_Us_Widget',
			__( 'Header call us', 'ova-dvents' ),
			array( 'description' => __( 'Show header call us', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$html.= '<li class="no-hover"><a href="#">'.$instance['text'].'</a></li>';
		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$text = ! empty( $instance['text'] ) ? $instance['text'] : '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>">
				<?php echo __( 'Text:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'text' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'text' ) ); ?>"
                    type="text"
                    value="<?php echo __( $text ); ?>"
            >
        </p>

		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['text'] = ( ! empty( $new_instance['text'] ) ) ? strip_tags( $new_instance['text'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Call_Us_Widget() {
	register_widget( 'Dvents_Call_Us_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Call_Us_Widget' );