<?php

class Dvents_Box_Text_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Box_Text_Widget',
			__( 'Dvents Text', 'ova-dvents' ),
			array( 'description' => __( 'Show text', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$html = $args['before_widget'];
		if (!empty($instance['title'])){
		    $html .= $args['before_title'].$instance['title'].$args['after_title'];
        }
		$html .= '
		    <div class="footer-section__subtitle">'.$instance['sub_title'].'</div>
            <div class="footer__info">
                <p>'.$instance['text'].'</p>
            </div>
		';
		if (!empty($instance['button_text'])){
		    $html .= '<a href="'.$instance['button_link'].'" class="btn btn-default btn-xs"><i class="icon"></i> '.$instance['button_text'].'</a>';
        }
		$html .= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title       = ! empty( $instance['title'] ) ? $instance['title'] : '';
		$sub_title = ! empty( $instance['sub_title'] ) ? $instance['sub_title'] : '';
		$text = ! empty( $instance['text'] ) ? $instance['text'] : '';
		$button_text = ! empty( $instance['button_text'] ) ? $instance['button_text'] : '';
		$button_link = ! empty( $instance['button_link'] ) ? $instance['button_link'] : '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                    type="text"
                    value="<?php echo __( $title ); ?>"
            >
        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'sub_title' ) ); ?>">
				<?php echo __( 'Sub title:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'sub_title' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'sub_title' ) ); ?>"
                    type="text"
                    value="<?php echo __( $sub_title ); ?>"
            >
        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>">
				<?php echo __( 'Text:', 'ova-dvents' ); ?>
            </label>
            <textarea
                    rows="3"
                    class="widefat" id="<?php echo __( $this->get_field_id( 'text' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'text' ) ); ?>"
                    type="text"><?php echo __( $text ); ?></textarea>
        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>">
				<?php echo __( 'Button text:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'button_text' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'button_text' ) ); ?>"
                    type="text"
                    value="<?php echo __( $button_text ); ?>"
            >
        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_link' ) ); ?>">
				<?php echo __( 'Button link:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'button_link' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'button_link' ) ); ?>"
                    type="text"
                    value="<?php echo __( $button_link ); ?>"
            >
        </p>


		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance         = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['sub_title'] = ( ! empty( $new_instance['sub_title'] ) ) ? strip_tags( $new_instance['sub_title'] ) : '';
		$instance['text'] = ( ! empty( $new_instance['text'] ) ) ? strip_tags( $new_instance['text'] ) : '';
		$instance['button_text'] = ( ! empty( $new_instance['button_text'] ) ) ? strip_tags( $new_instance['button_text'] ) : '';
		$instance['button_link'] = ( ! empty( $new_instance['button_link'] ) ) ? strip_tags( $new_instance['button_link'] ) : '';

		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Box_Text_Widget() {
	register_widget( 'Dvents_Box_Text_Widget' );
}

add_action( 'widgets_init', 'Register_Dvents_Box_Text_Widget' );