<?php

class Dvents_Blog_Tag_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Blog_Tag_Widget',
			__( 'Tags', 'ova-dvents' ),
			array( 'description' => __( 'Show tags', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$title = '';
		if ($instance['title']!=''){
		    $title = '<h3 class="widget-title"><i class="ui-decor-2 bg-primary"></i>'.$instance['title'].'</h3>';
        }
        $tags = get_tags();
		$html.= '
		    <section class="widget section-sidebar">
                '.$title.'
                <div class="widget-content">
                  <ul class="list-tags list-unstyled">';
		foreach ( $tags as $tag ) {
			$html .= '<li class="list-tags__item"><a href="'.get_tag_link( $tag->term_id ).'" class="list-tags__link bg-primary_h">'.$tag->name.'</a></li>';
		}
        $html.= '  </ul>
                </div>
              </section>
		    ';

		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : __( '', 'ova-dvents'  );
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
                <?php echo __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                type="text"
                value="<?php echo __( $title ); ?>"
            >
        </p>
		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Blog_Tag_Widget() {
	register_widget( 'Dvents_Blog_Tag_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Blog_Tag_Widget' );