<?php

class Dvents_Blog_Search_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'devents_blog_search_widget',
			__( 'Search form', 'ova-dvents' ),
			array( 'description' => __( 'A search form', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$title = '';
		if ($instance['title']!=''){
		    $title = '<h3 class="widget-title"><i class="ui-decor-2"></i>'.$instance['title'].'</h3>';
        }
		$html.= '
		     <div data-stellar-background-ratio="0.4" class="widget widget-searce section-texture bg-primary stellar">
		        '.$title.'
                <form id="search-global-form" class="form-sidebar" method="get" role="search" action="'. home_url( '/' ) .'" >
                  <input name="s" type="text" class="form-sidebar__input"/>
                  <button class="form-sidebar__btn" type="submit" ><i class="icon icon-magnifier"></i></button>
                </form>
              </div>
		';

		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : __( '', 'ova-dvents'  );
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
                <?php esc_attr_e( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                type="text"
                value="<?php echo __( $title ); ?>"
            >
        </p>

		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function register_dvents_blog_search_widget() {
	register_widget( 'Dvents_Blog_Search_Widget' );
}
add_action( 'widgets_init', 'register_dvents_blog_search_widget' );