<?php

class Dvents_Blog_Recent_Post_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Blog_Recent_Post_Widget',
			__( 'Recent post', 'ova-dvents' ),
			array( 'description' => __( 'Dvents Show Recent Post', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = '';
		$title = '';
		if ($instance['title']!=''){
		    $title = '<h3 class="widget-title"><i class="ui-decor-2 bg-primary"></i>'.$instance['title'].'</h3>';
        }
		$args = array(
			'numberposts' => (empty($instance['limit'])?0:$instance['limit']),
			'offset' => 0,
			'orderby' => 'post_date',
			'order' => 'DESC',
			'include' => '',
			'exclude' => '',
			'meta_key' => '',
			'meta_value' =>'',
			'post_type' => 'post',
			'post_status' => 'publish',
			'suppress_filters' => true
		);

		$recent_posts = wp_get_recent_posts( $args, ARRAY_A );
		$html.= '
		     <section class="widget section-sidebar">
                '.$title.'
                <div class="widget-content">';
		foreach ( $recent_posts as $recent_post ) {
		    $src = wp_get_attachment_image_src(get_post_thumbnail_id($recent_post['ID']),'full');
		    $image = '';
			$style = '';
		    if ($instance['show_image'] == 1) {
			    $image = '<div class="post-widget__media"><a href="' . get_the_permalink( $recent_post['ID'] ) . '"><img  src="' . $src[0] . '" alt="' . get_the_title( $recent_post['ID'] ) . '" class="img-responsive"/></a></div>';
		    }else{
		        $style = 'padding-left: 0';
            }

		    $date = '';
		    if ($instance['show_date'] == 1) {
			    $date = '<div class="post-widget__date">
                            <div  class="text-primary">'.get_the_date('',$recent_post['ID']).'</div>
                          </div>';
		    }

			$html .= '<div class="post-widget clearfix">
                        '.$image.'
                        <div class="post-widget__inner" style="'.$style.'"><a href="'.get_the_permalink($recent_post['ID']).'" class="post-widget__title">'.get_the_title($recent_post['ID']).'</a>
                          '.$date.'
                        </div>
                      </div>';
		}
         $html.= '</div>
              </section>
		';


		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : __( '', 'ova-dvents'  );
		$limit = ! empty( $instance['limit'] ) ? $instance['limit'] : 3;
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
                <?php echo __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                type="text"
                value="<?php echo __( $title ); ?>"
            >
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>">
				<?php echo __( 'Limit:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'limit' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'limit' ) ); ?>"
                    type="text"
                    value="<?php echo $limit ?>"
            >
        </p>
        <p>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'show_image' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'show_image' ) ); ?>"
                    type="checkbox" <?php echo (isset($instance['show_image']) && $instance['show_image'] == 1)?'checked':'' ?>
                    value="1"
            >
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_image' ) ); ?>">
				<?php echo __( 'Show image', 'ova-dvents' ); ?>
            </label>

        </p>

        <p>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'show_date' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'show_date' ) ); ?>"
                    type="checkbox" <?php echo (isset($instance['show_date']) && $instance['show_date'] == 1)?'checked':'' ?>
                    value="1"
            >
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_date' ) ); ?>">
				<?php echo __( 'Show date', 'ova-dvents' ); ?>
            </label>

        </p>


		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['limit'] = ( ! empty( $new_instance['limit'] ) ) ? strip_tags( $new_instance['limit'] ) : '';
		$instance['show_image'] = ( ! empty( $new_instance['show_image'] ) ) ? strip_tags( $new_instance['show_image'] ) : '';
		$instance['show_date'] = ( ! empty( $new_instance['show_date'] ) ) ? strip_tags( $new_instance['show_date'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Blog_Recent_Post_Widget() {
	register_widget( 'Dvents_Blog_Recent_Post_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Blog_Recent_Post_Widget' );