<?php

class Dvents_Blog_Featured_Post_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Blog_Featured_Post_Widget',
			__( 'Featured post', 'ova-dvents' ),
			array( 'description' => __( 'Dvents Show Featured Post', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		
		$html  = '';
		
		$title = '';

		if ( $instance['title'] != '' ) {
			$title = '<h3 class="widget-title"><i class="ui-decor-2 bg-primary"></i>' . $instance['title'] . '</h3>';
		}

		$args = array(
			'post_type'      => 'post',
			'post_status'    => array( 'publish' ),
			'orderby'        => 'rand',
			'posts_per_page' => 1,
			'meta_query'     => array(
				array(
					'key'   => 'dvents_met_post_featured',
					'value' => 1,
				),
			)
		);


		$query = new WP_Query( $args );
		if ( $query->have_posts() ) {
			$query->the_post();
			$src  = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
			
			$html .= '<section class="widget widget-best-post section-sidebar">
                ' . $title . '
                	<div class="widget-content">
                 		 	<div class="post-widget-2 clearfix">

				                    <div class="post-widget-2__media area-bg area-bg_dark area-bg_op_60 post-widget-featured">
				                    	<img src="' . $src[0] . '" alt="' . get_the_title( get_the_ID() ) . '" class="img-responsive"/>
				                    </div>
		                    
				                    <div class="post-widget-2__inner area-bg__inner">
					                    <div class="post-widget-2__date">
					                        <div class="text-primary">' . get_the_date( '', get_the_ID() ) . '</div>
					                    </div>
					                    <a href="' . get_the_permalink( get_the_ID() ) . '" class="post-widget-2__title">' . get_the_title( get_the_ID() ) .'</a>
					                </div>

			                  	
							</div>
		            </div>
                </section>';
		}
		
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : __( '', 'ova-dvents' );
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                    type="text"
                    value="<?php echo __( $title ); ?>"
            >
        </p>
		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Blog_Featured_Post_Widget() {
	register_widget( 'Dvents_Blog_Featured_Post_Widget' );
}

add_action( 'widgets_init', 'Register_Dvents_Blog_Featured_Post_Widget' );