<?php

class Dvents_Blog_Categories_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Blog_Categories_Widget',
			__( 'Categories', 'ova-dvents' ),
			array( 'description' => __( 'Show categories', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$title = '';
		if ($instance['title']!=''){
		    $title = '<h3 class="widget-title"><i class="ui-decor-2 bg-primary"></i>'.$instance['title'].'</h3>';
        }
        $categories = get_categories();
		$html.= '
		     <section class="widget section-sidebar">
		     '.$title.'
                <div class="widget-content">
                  <ul class="widget-list list list-mark-5">';
		foreach ( $categories as $category ) {
		    $count = ($instance['show_post_count'] == 1)?('('.$category->category_count).')':'';
			$html.='<li class="widget-list__item"><a href="'.get_category_link($category->term_id).'" class="widget-list__link text-primary_h">'.$category->name.$count.'</a></li>';
		}
        $html.=   '</ul>
                </div>
              </section>
		';

		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : __( '', 'ova-dvents'  );
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
                <?php echo  __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                type="text"
                value="<?php echo __( $title ); ?>"
            >
        </p>

        <p>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'show_post_count' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'show_post_count' ) ); ?>"
                    type="checkbox" <?php echo (isset($instance['show_post_count']) && $instance['show_post_count'] == 1)?'checked':'' ?>
                    value="1"
            >
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php esc_attr_e( 'Show post counts:', 'ova-dvents' ); ?>
            </label>

        </p>


		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['show_post_count'] = ( ! empty( $new_instance['show_post_count'] ) ) ? strip_tags( $new_instance['show_post_count'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Blog_Categories_Widget() {
	register_widget( 'Dvents_Blog_Categories_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Blog_Categories_Widget' );