<?php
add_action( 'init', 'vc_dvents_why_us_item', 1000 );
function vc_dvents_why_us_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Why us item", 'ova-dvents' ),
			"base"     => "dvents_why_us_item",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"default"    => '',
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"default"    => '',
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Description", 'ova-dvents' ),
					"param_name" => "des",
					"default"    => '',
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_why_us_item', 'dvents_why_us_item' );
function dvents_why_us_item( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'des'   => '',
			'title' => '',
			'icon'  => '',
			'show_line'	=> 'true',
			'class' => '',
		), $atts );
	$icon = ($atts['icon']!='')?'<i class="b-advantages-2__icon '.$atts['icon'].'"></i>':'';
	$html = '<section class="b-advantages-2 b-advantages-2_mod-a">'.$icon.'
                <div class="b-advantages-2__inner">
                  <h3 class="ova_title b-advantages-2__title ui-title-inner bg-primary_b">'.$atts['title'].'</h3>
                  <div class="b-advantages-2__info">'.$atts['des'].'</div>
                </div>
             </section>';

  	if( $atts['show_line'] == 'false' ){
	$html .= '<style>.ova_title.b-advantages-2__title:before{ background: transparent; }</style>';
    }  

	return $html;
}
