<?php
add_action( 'init', 'vc_dvents_wellcome_item', 1000 );
function vc_dvents_wellcome_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Wellcome item", 'ova-dvents' ),
			"base"     => "dvents_wellcome_item",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"value"      => "",
					"description" => esc_html__( "For example: icon-puzzle. Find here: http://simplelineicons.com/", 'ova-dvents' )
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Description", 'ova-dvents' ),
					"param_name" => "des",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button text", 'ova-dvents' ),
					"param_name" => "button_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "button Link", 'ova-dvents' ),
					"param_name" => "button_link",
					"value"      => ""
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line in button", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_wellcome_item', 'dvents_wellcome_item' );
function dvents_wellcome_item( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'icon'        => '',
			'title'       => '',
			'button_link' => '',
			'button_text' => '',
			'des'         => '',
			'show_line'	=> 'true',
			'class'       => '',
		), $atts );
	
	$html = '';

	
	

	$html .= '<section class="b-advantages b-advantages-1 '.$atts['class'].'">';

				$html .= $atts['icon'] ? '<i class="b-advantages__icon text-primary '.$atts['icon'].'"></i>' : '';

	            $html .= '<div class="b-advantages__inner">';

	              $html .= $atts['title'] ? '<h3 class="b-advantages__title ui-title-inner">'.$atts['title'].'</h3>' : '';
	              
	              $html .= $atts['des'] ? '<div class="b-advantages__info">' . $atts['des'] . '</div>' : '';
	              
	              if( $atts['button_text'] != '' ){
						$html .= '<a href="'.$atts['button_link'].'" class="btn btn-default btn-xs">';
						$html .= $atts['show_line'] == 'true' ? '<i class="icon"></i>': '';
						$html .= $atts['button_text'].'</a>';
					}

	            $html .= '</div>
             </section>';

	return $html;
}
