<?php
add_action( 'init', 'vc_dvents_wellcome', 1000 );
function vc_dvents_wellcome() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Wellcome", 'ova-dvents' ),
			"base"     => "dvents_wellcome",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => "",
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"value"      => "",
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Background left position", 'ova-dvents' ),
					"param_name" => "bg_left",
					"value"      => "",
				),
				

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Highlight text", 'ova-dvents' ),
					"param_name" => "highlight_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textarea_html",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Content", 'ova-dvents' ),
					"param_name" => "content",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button text", 'ova-dvents' ),
					"param_name" => "button_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "button Link", 'ova-dvents' ),
					"param_name" => "button_link",
					"value"      => ""
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line in button", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_wellcome', 'dvents_wellcome' );
function dvents_wellcome( $atts, $content = null ) {
	$atts   = shortcode_atts(
		array(
			'icon'           => '',
			'image'          => '',
			'title'          => '',
			'button_link'    => '',
			'button_text'    => '',
			'normal_text'    => '',
			'highlight_text' => '',
			'bg_left'			=> '',
			'show_line'		=> 'true',
			'class'          => '',
		), $atts );

	$button = '';
	if( $atts['button_text'] != '' && $atts['show_line'] == 'true' ){
		$button = '<a href="' . $atts['button_link'] . '" class="btn btn-default btn-xs"><i class="icon"></i>' . $atts['button_text'] . '</a>';
	}else if( $atts['button_text'] != '' && $atts['show_line'] == 'false' ){
		$button = '<a href="' . $atts['button_link'] . '" class="btn btn-default btn-xs">' . $atts['button_text'] . '</a>';
	}
	
	
	$icon   = '';
	if ( $atts['icon'] != '' ) {
		$src  = wp_get_attachment_image_src( $atts['icon'], 'full' );
		$icon = '<img src="' . $src[0] . '" alt="' . $atts['title'] . '">';
	}

	$image = '';
	if ( $atts['image'] != '' ) {
		$src   = wp_get_attachment_image_src( $atts['image'], 'full' );
		$image = '<img src="' . $src[0] . '" alt="' . $atts['title'] . '" class="img-w-radius img-responsive" >';
	}

	if ( $atts['bg_left'] != '' ) {
		$bg_left   = wp_get_attachment_image_src( $atts['bg_left'], 'full' );
	}else{
		$bg_left = '';
	}
	$url_bg = isset( $bg_left[0] ) ? $bg_left[0] : '';



	$html = '<section class="section-type-1 ' . $atts['class'] . '">
                <div class="label-vertical" style="background: url('.$url_bg.') no-repeat 0 0">
	                <div class="container">
		                <div class="row">
		                    <div class="col-md-4">' . $image . '</div>
			                <div class="col-md-8">
				                <div class="section-type-1__inner">
					                  <div class="ui-decor-1">' . $icon . '</div>
					                  <h2 class="ui-title-block">' . $atts['normal_text'] . '<span class="text-primary"> ' . $atts['highlight_text'] . '</span></h2>
					                  <div class="ui-subtitle-block">' . $atts['title'] . '</div>
				                    	<p>' . do_shortcode( $content ) . '</p>
				                      ' . $button . '
				                  </div>
				            </div>    
		                </div>
	                </div>
                </div>
            </section>';

	return $html;
}
