<?php
add_action( 'init', 'vc_dvents_team_v2', 1000 );
function vc_dvents_team_v2() {
	if ( function_exists( 'vc_map' ) ) {
		$term      = get_terms( 'teamgroup' );
		$termsSlug = array();
		foreach ( $term as $item ) {
			$termsSlug[] = $item->slug;
		}

		vc_map( array(
			"name"     => __( "Team v2", 'ova-dvents' ),
			"base"     => "dvents_team_v2",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Team Groups", 'ova-dvents' ),
					"param_name" => "groups",
					"value"      => implode( ',', $termsSlug )
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => "4"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Order", 'ova-dvents' ),
					"param_name" => "order",
					"value"      => array(
						__( 'ASC', 'ova-dvents' )  => "ASC",
						__( 'DESC', 'ova-dvents' ) => "DESC",
					),
					"default"    => "ASC"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_team_v2', 'dvents_team_v2' );
function dvents_team_v2( $atts, $content = null ) {

	$term      = get_terms( 'teamgroup' );
	$termsSlug = array();
	foreach ( $term as $item ) {
		$termsSlug[] = $item->slug;
	}

	$atts       = shortcode_atts(
		array(
			'groups'         => implode( ',', $termsSlug ),
			'limit'          => '4',
			'order'          => 'ASC',
			'show_line'		=> 'true',
			'class'          => '',
		), $atts );

	$groups     = explode( ',', $atts['groups'] );
	$listgroups = array();
	$groupIDs   = array();
	$listabs    = array();
	foreach ( $groups as $group ) {
		$term         = get_term_by( 'slug', $group, 'teamgroup' );
		$listgroups[] = $term;
		$groupIDs[]   = $term->term_id;
		$listabs[]    = '<li><a href="" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
	}

	$args = array(
		'post_type'      => 'team',
		'tax_query'      => array(
			array(
				'taxonomy' => 'teamgroup',
				'field'    => 'term_id',
				'terms'    => $groupIDs,
				'operator' => 'IN',
			)

		),
		'post_status'    => array( 'publish' ),
		'meta_key'       => 'dvents_met_team_order',
		'orderby'        => 'meta_value_num',
		'order'          => $atts['order'],
		'posts_per_page' => $atts['limit']
	);


	$query = new WP_Query( $args );
	$html = '';
	while ($query->have_posts()) {
		$query->the_post();
		$groups     = wp_get_post_terms( get_the_ID(), 'teamgroup' );
		$listgroups = array();
		foreach ( $groups as $v ) {
			$listgroups[] = $v->name;
		}

		$src = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'full');
		$image = (isset($src[0]))?'<img src="'.$src[0].'" alt="'.get_the_title().'" class="img-responsive"/>':'';

		$fb = get_post_meta( get_the_ID(), 'dvents_met_team_facebook', true );
		$fb = ( $fb != '' ) ? '<li class="social-net__item"><a href="' . $fb . '" class="social-net__link text-primary_h"><i class="icon fa fa-facebook"></i></a></li>' : '';

		$tw = get_post_meta( get_the_ID(), 'dvents_met_team_twitter', true );
		$tw = ( $tw != '' ) ? '<li class="social-net__item"><a href="' . $tw . '" class="social-net__link text-primary_h"><i class="icon fa fa-twitter"></i></a></li>' : '';

		$gg = get_post_meta( get_the_ID(), 'dvents_met_team_google_plus', true );
		$gg = ( $gg != '' ) ? '<li class="social-net__item"><a href="' . $gg . '" class="social-net__link text-primary_h"><i class="icon fa fa-google-plus"></i></a></li>' : '';

		$in = get_post_meta( get_the_ID(), 'dvents_met_team_instagram', true );
		$in = ( $gg != '' ) ? '<li class="social-net__item"><a href="' . $in . '" class="social-net__link text-primary_h"><i class="icon fa fa-instagram"></i></a></li>' : '';



		$html .= ' 
 			<section class="b-team b-team_mod-a ">
                <div class="b-team__media">'.$image.'</div>
                <div class="b-team__inner" >';

                  $html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 bg-primary"></div>' : '';
                  
                  $html .= '<h3 class="b-team__name ui-title-inner">'.get_the_title().'</h3>
                  <div class="b-team__category">'.implode(', ',$listgroups).'</div>
                  <div class="b-team__description">'.get_the_excerpt().'</div>
                  <ul class="social-net list-inline">
                    ' . $tw . $fb . $gg . $in . '
                  </ul>
                </div>
              </section> ';
	}
	wp_reset_query();

	return $html;
}
