<?php
add_action( 'init', 'vc_dvents_team', 1000 );
function vc_dvents_team() {
	if ( function_exists( 'vc_map' ) ) {
		$term      = get_terms( 'teamgroup' );
		$termsSlug = array();
		foreach ( $term as $item ) {
			$termsSlug[] = $item->slug;
		}

		vc_map( array(
			"name"     => __( "Team", 'ova-dvents' ),
			"base"     => "dvents_team",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Team Groups", 'ova-dvents' ),
					"param_name" => "groups",
					"value"      => implode( ',', $termsSlug )
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => "8"
				),


				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Order", 'ova-dvents' ),
					"param_name" => "order",
					"value"      => array(
						__( 'ASC', 'ova-dvents' )  => "ASC",
						__( 'DESC', 'ova-dvents' ) => "DESC",
					),
					"default"    => "ASC"
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '700'
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show navigation", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => false,
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => false,
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_team', 'dvents_team' );
function dvents_team( $atts, $content = null ) {

	$term      = get_terms( 'teamgroup' );
	$termsSlug = array();
	foreach ( $term as $item ) {
		$termsSlug[] = $item->slug;
	}

	$atts       = shortcode_atts(
		array(
			'groups'         => implode( ',', $termsSlug ),
			'limit'          => '8',
			'order'          => 'ASC',
			'time_next'      => '700',
			'show_dot'       => false,
			'stop_on_hover'  => false,
			'show_line'	=> 'true',
			'class'          => '',
		), $atts );
	$groups     = explode( ',', $atts['groups'] );
	$listgroups = array();
	$groupIDs   = array();
	$listabs    = array();
	foreach ( $groups as $group ) {
		$term         = get_term_by( 'slug', $group, 'teamgroup' );
		$listgroups[] = $term;
		$groupIDs[]   = $term->term_id;
		$listabs[]    = '<li><a href="" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
	}

	$args = array(
		'post_type'      => 'team',
		'tax_query'      => array(
			array(
				'taxonomy' => 'teamgroup',
				'field'    => 'term_id',
				'terms'    => $groupIDs,
				'operator' => 'IN',
			)

		),
		'post_status'    => array( 'publish' ),
		'meta_key'       => 'dvents_met_team_order',
		'orderby'        => 'meta_value_num',
		'order'          => $atts['order'],
		'posts_per_page' => $atts['limit']
	);

	$atts['show_dot']      = $atts['show_dot'] == true ? 'true' : 'false';
	$atts['stop_on_hover'] = $atts['stop_on_hover'] == true ? 'true' : 'false';


	$query = new WP_Query( $args );
	$html = '
	<div 
	data-min480="1" 
	data-min768="1" 
	data-min992="1" 
	data-min1200="2" 
	data-pagination="false" 
	data-navigation="' . $atts['show_dot'] . '" 
	data-auto-play="' . $atts['time_next'] . '" 
	data-stop-on-hover="' . $atts['stop_on_hover'] . '" 
	class="owl-carousel owl-theme enable-owl-carousel  ' . $atts['class'] . ' ">';

	while ( $query->have_posts() ) {
		$query->the_post();
		$groups     = wp_get_post_terms( get_the_ID(), 'teamgroup' );
		$listgroups = array();
		foreach ( $groups as $v ) {
			$listgroups[] = $v->name;
		}
		$fb = get_post_meta( get_the_ID(), 'dvents_met_team_facebook', true );
		$fb = ( $fb != '' ) ? '<li class="social-net__item"><a href="' . $fb . '" class="social-net__link text-primary_h"><i class="icon fa fa-facebook"></i></a></li>' : '';

		$tw = get_post_meta( get_the_ID(), 'dvents_met_team_twitter', true );
		$tw = ( $tw != '' ) ? '<li class="social-net__item"><a href="' . $tw . '" class="social-net__link text-primary_h"><i class="icon fa fa-twitter"></i></a></li>' : '';

		$gg = get_post_meta( get_the_ID(), 'dvents_met_team_google_plus', true );
		$gg = ( $gg != '' ) ? '<li class="social-net__item"><a href="' . $gg . '" class="social-net__link text-primary_h"><i class="icon fa fa-google-plus"></i></a></li>' : '';

		$in = get_post_meta( get_the_ID(), 'dvents_met_team_instagram', true );
		$in = ( $gg != '' ) ? '<li class="social-net__item"><a href="' . $in . '" class="social-net__link text-primary_h"><i class="icon fa fa-instagram"></i></a></li>' : '';

		$src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

		$html .= '
		<section class="b-team b-team_light">
			<div class="b-team__media"><img src="' . $src[0] . '" alt="' . get_the_title() . '" class="img-responsive"/></div>
			<div class="b-team__inner">';
				
				$html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 bg-primary"></div>' : '';

				$html .= '<h3 class="b-team__name ui-title-inner">' . get_the_title() . '</h3>
				<div class="b-team__category">' . implode( ', ', $listgroups ) . '</div>
				<div class="b-team__description">' . get_the_content() . '</div>
				<ul class="social-net list-inline">
					' . $tw . $fb . $gg . $in . '
				</ul>
			</div>
		</section>';
	}

	$html .= '</div>';
	wp_reset_query();

	return $html;
}
