<?php
add_action( 'init', 'vc_dvents_dvents_taglines_v2', 1000 );
function vc_dvents_dvents_taglines_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Tag lines v2", 'ova-dvents' ),
			"base"     => "dvents_taglines_v2",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Highlight text", 'ova-dvents' ),
					"param_name" => "highlight_text",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),


			)
		) );

	}
}

add_shortcode( 'dvents_taglines_v2', 'dvents_taglines_v2' );
function dvents_taglines_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'title'          => '',
			'sub_title'      => '',
			'normal_text'    => '',
			'highlight_text' => '',
			'class'          => '',
		), $atts );

	$html = '
		 <div class="area-bg__inner"> 
          <div class="b-advertisement__label bg-primary">' . $atts['normal_text'] . '<strong> ' . $atts['highlight_text'] . '</strong></div>
          <h2 class="b-advertisement__title ui-title-block">' . $atts['title'] . '</h2>
          <div class="b-advertisement__info">' . $atts['sub_title'] . '</div>
        </div>
	';

	return $html;
}
