<?php
add_action( 'init', 'vc_dvents_dvents_taglines', 1000 );
function vc_dvents_dvents_taglines() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Tag lines", 'ova-dvents' ),
			"base"     => "dvents_taglines",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),


			)
		) );

	}
}

add_shortcode( 'dvents_taglines', 'dvents_dvents_taglines' );
function dvents_dvents_taglines( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'title'     => '',
			'sub_title' => '',
			'show_line'	=> 'true',
			'class'     => '',
		), $atts );

	$html = '
		 <div class="area-bg__inner">
	          <div class="container">
	            <div class="row">
					<div class="col-sm-10 col-sm-offset-1">
			            <div class="b-taglines__inner">
			              <h2 class="b-taglines__title">' . $atts['title'] . '</h2>
			              <div class="b-taglines__text">' . $atts['sub_title'] . '</div>
			            </div>
		            </div>
	            </div>
	          </div>
          </div>
	';

	if( $atts['show_line'] == 'false' ){
		$html .= '<style>.b-taglines__inner:before{ background: none; }</style>';
	}

	return $html;
}
