<?php
add_action( 'init', 'vc_dvents_social_icon', 1000 );
function vc_dvents_social_icon() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Social icon", 'ova-dvents' ),
			"base"     => "dvents_social_icon",
			"as_child" => array( 'only' => 'dvents_social' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Icon", 'ova-dvents' ),
					"param_name"  => "icon",
					"value"       => "",
					"description" => esc_html__( "For example: fa-facebook. Find here: http://fontawesome.io/icons/", 'ova-dvents' )
				),
				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Open in link new tab", 'ova-dvents' ),
					"param_name" => "target",
					"value"      => false,
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Link", 'ova-dvents' ),
					"param_name" => "link",
					"value"      => ""
				),

			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_social_icon extends WPBakeryShortCode {
			}
		}

	}
}


add_shortcode( 'dvents_social_icon', 'dvents_social_icon' );
function dvents_social_icon( $atts, $content = null ) {
	$atts   = shortcode_atts(
		array(
			'icon'   => '',
			'target' => false,
			'link'   => 0,
		), $atts );
	$target = ( $atts['target'] == true ) ? 'target = "_blank"' : '';
	$html   = '<li class="social-net__item"><a '.$target.' href="' . $atts['link'] . '" class="social-net__link text-primary_h"><i class="icon fa ' . $atts['icon'] . '"></i></a></li>';

	return $html;
}
