<?php
add_action( 'init', 'vc_dvents_social', 1000 );
function vc_dvents_social() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Social", 'ova-dvents' ),
			"base"                    => "dvents_social",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_social_icon' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_social extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_social', 'dvents_social' );
function dvents_social( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'class'    => '',
		), $atts );
	$html = ' <ul class="social-net list-inline '.$atts['class'].'">'.do_shortcode($content).'</ul>';

	return $html;
}
