<?php
add_action( 'init', 'vc_dvents_slidershow_item', 1000 );
function vc_dvents_slidershow_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Slideshow item", 'ova-dvents' ),
			"base"     => "dvents_slideshow_item",
			"as_child" => array( 'only' => 'dvents_slidershow' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Small text", 'ova-dvents' ),
					"param_name" => "small_text",
					"default"    => '',
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Large text", 'ova-dvents' ),
					"param_name" => "large_text",
					"default"    => '',
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show vertical line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Text button left", 'ova-dvents' ),
					"param_name" => "text_button_left",
					"default"    => '',
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Link button left", 'ova-dvents' ),
					"param_name" => "link_button_left",
					"default"    => '',
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Text button right", 'ova-dvents' ),
					"param_name" => "text_button_right",
					"default"    => '',
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Link button right", 'ova-dvents' ),
					"param_name" => "link_button_right",
					"default"    => '',
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Background", 'ova-dvents' ),
					"param_name" => "background",
					"value"      => ""
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image top left", 'ova-dvents' ),
					"param_name" => "image_top_left",
					"value"      => ""
				),


				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image top right", 'ova-dvents' ),
					"param_name" => "image_top_right",
					"value"      => ""
				),


				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image bottom left", 'ova-dvents' ),
					"param_name" => "image_bottom_left",
					"value"      => ""
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image bottom right", 'ova-dvents' ),
					"param_name" => "image_bottom_right",
					"value"      => ""
				),




				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_slideshow_item extends WPBakeryShortCode {
			}
		}


	}
}


add_shortcode( 'dvents_slideshow_item', 'dvents_slideshow_item' );
function dvents_slideshow_item( $atts, $content = null ) {
	$atts  = shortcode_atts(
		array(
			'background'         => '',
			'image_top_left'     => '',
			'image_top_right'    => '',
			'image_bottom_left'  => '',
			'image_bottom_right' => '',
			'small_text'         => '',
			'large_text'         => '',
			'text_button_left'   => '',
			'link_button_left'   => '',
			'text_button_right'  => '',
			'link_button_right'  => '',
			'show_line'		=> 'true',
			'class'              => '',
		), $atts );
	$src = wp_get_attachment_image_src($atts['background'],'full');
	$background = ( isset($src[0]))?'<img src="'.$src[0].'" alt="'.$atts['small_text'].'" class="sp-image"/>':'';



	$image_top_left = '';
	if ($atts['image_top_right']!='') {
		$src            = wp_get_attachment_image_src( $atts['image_top_left'], 'full' );
		$image_top_left = ( isset( $src[0] ) ) ? ' 
	    <div data-width="100%" 
	    data-show-transition="right" 
	    data-hide-transition="left" 
	    data-show-duration="1200" 
	    data-show-delay="2000" 
	    data-hide-delay="400" 
	    data-vertical="190px" 
	    data-horizontal="0" 
	    class="main-slider__item-1 sp-layer"><img src="' . $src[0] . '" alt="Item"/></div>' : '';
	}



	$image_top_right = '';
	if ($atts['image_top_right']!='') {
		$src             = wp_get_attachment_image_src( $atts['image_top_right'], 'full' );
		$image_top_right = ( isset( $src[0] ) ) ? ' 
	    <div data-width="100%" 
	    data-show-transition="left" 
	    data-hide-transition="left" 
	    data-show-duration="1200" 
	    data-show-delay="2000" 
	    data-hide-delay="400" 
	    data-vertical="250px" 
	    data-horizontal="100%" 
	    class="main-slider__item-2 sp-layer"><img src="' . $src[0] . '" alt="Item"/></div>' : '';
	}



	$image_bottom_left = '';
	if ($atts['image_bottom_left']!='') {
		$src             = wp_get_attachment_image_src( $atts['image_bottom_left'], 'full' );
		$image_bottom_left = ( isset( $src[0] ) ) ? ' 
	    <div data-width="100%" 
	    data-show-transition="right" 
	    data-hide-transition="left" 
	    data-show-duration="1200" 
	    data-show-delay="2000" 
	    data-hide-delay="400" 
	    data-vertical="630px" 
	    data-horizontal="0" 
	    class="main-slider__item-3 sp-layer"><img src="' . $src[0] . '" alt="Item"/></div>' : '';
	}


	$image_bottom_right = '';
	if ($atts['image_bottom_left']!='') {
		$src             = wp_get_attachment_image_src( $atts['image_bottom_right'], 'full' );
		$image_bottom_right = ( isset( $src[0] ) ) ? ' 
	    <div data-width="100%" 
	    data-show-transition="left" 
	    data-hide-transition="left" 
	    data-show-duration="1200" 
	    data-show-delay="2000" 
	    data-hide-delay="400" 
	    data-vertical="630px" 
	    data-horizontal="95%" 
	    class="main-slider__item-3 sp-layer"><img src="' . $src[0] . '" alt="Item"/></div>' : '';
	}


	$small_text = ($atts['small_text']!='')?'
	<div 
	data-width="100%" 
	data-show-transition="left" 
	data-hide-transition="left" 
	data-show-duration="2000" 
	data-show-delay="1200" 
	data-hide-delay="400" 
	class="main-slider__info sp-layer">'.$atts['small_text'].'</div>':'';



	$large_text = ($atts['large_text']!='')?'
	<h2 data-width="100%" 
	data-show-transition="left" 
	data-hide-transition="left" 
	data-show-duration="800" 
	data-show-delay="400" 
	data-hide-delay="400" 
	class="main-slider__title sp-layer">'.$atts['large_text'].'</h2>':'';


	$button_left = '';
	$button_right = '';
	if ($atts['text_button_left']!='' && $atts['text_button_right']!=''){
		$button_left = '<a href="'.$atts['link_button_left'].'" class="main-slider__btn btn btn-primary">'.$atts['text_button_left'].'</a>';
		$button_right = '<a href="'.$atts['link_button_right'].'" class="main-slider__btn btn btn-default">'.$atts['text_button_right'].'</a>';
	}elseif ($atts['link_button_left']!='' && $atts['text_button_right'] ==''){
		$button_left = '<a href="'.$atts['link_button_left'].'" class="main-slider__btn btn btn-default">'.$atts['text_button_left'].'</a>';
	}



	$html = '<div class="sp-slide ' . $atts['class'] . '">
				'.$background.'
	            <div class="container">
	              <div class="row">
	                <div class="col-sm-10 col-sm-offset-1">
	                 '.$image_top_left.$image_top_right.$image_bottom_left.$image_bottom_right.$small_text.$large_text.'
	                  <div data-width="100%" data-show-transition="left" data-hide-transition="left" data-show-duration="1200" data-show-delay="600" data-hide-delay="400" class="sp-layer">';
	                    $html .= $atts['show_line'] == 'true' ? '<div class="main-slider__decor bg-primary"></div>' : '';
	                  $html .= '</div>
	                  <div data-width="100%" data-show-transition="left" data-hide-transition="left" data-show-duration="1200" data-show-delay="2000" data-hide-delay="400" class="sp-layer">'.$button_left.$button_right.'</div>
	                </div>
	              </div>
	            </div>
             </div>';

	return $html;
}
