<?php
add_action( 'init', 'vc_dvents_slidershow', 1000 );
function vc_dvents_slidershow() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Slideshow", 'ova-dvents' ),
			"base"                    => "dvents_slidershow",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_slideshow_item' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Display arrows", 'ova-dvents' ),
					"param_name" => "dis_arrows",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Display buttons", 'ova-dvents' ),
					"param_name" => "dis_buttons",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Autoplay", 'ova-dvents' ),
					"param_name" => "autoplay",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Auto Scale Layers", 'ova-dvents' ),
					"param_name" => "auto_scale_layers",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Shuffle", 'ova-dvents' ),
					"param_name" => "shuffle",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),




				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Width", 'ova-dvents' ),
					"param_name"  => "width",
					"value"       => '100%',
					"description" => esc_html__( "Sets the width of the slide. Can be set to a fixed value, like 900 (indicating 900 pixels), or to a percentage value, like '100%'.", 'ova-dvents' )
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Height", 'ova-dvents' ),
					"param_name"  => "height",
					"value"       => '860',
					"description" => esc_html__( "Sets the width of the slide. Can be set to a fixed value, like 900 (indicating 900 pixels), or to a percentage value, like '100%'.", 'ova-dvents' )
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Padding Top Desktop", 'ova-dvents' ),
					"param_name"  => "padding_top_desk",
					"value"       => '270px',
					"description" => esc_html__( "Sets the width of the slide. Can be set to a fixed value, like 270px, or to a percentage value, like '10%'.", 'ova-dvents' )
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Height Mobile", 'ova-dvents' ),
					"param_name"  => "height_m",
					"value"       => '400px',
					"description" => esc_html__( "Sets the width of the slide. Can be set to a fixed value, like 400px or to a percentage value, like '100%'.", 'ova-dvents' )
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Padding Top Mobile", 'ova-dvents' ),
					"param_name"  => "padding_top_mobile",
					"value"       => '80px',
					"description" => esc_html__( "Sets the width of the slide. Can be set to a fixed value, like 270px, or to a percentage value, like '10%'.", 'ova-dvents' )
				),

				array(
					"type"        => "colorpicker",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Background Overlay", 'ova-dvents' ),
					"param_name"  => "bg_overlay",
					"value"       => 'rgba(0, 0, 0, 0.65)',
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_slidershow extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_slidershow', 'dvents_slidershow' );
function dvents_slidershow( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'dis_arrows'        => 'true',
			'dis_buttons'       => 'true',
			'auto_scale_layers' => 'true',
			'autoplay'          => 'true',
			'time_next'         => 8000,
			'width'             => '100%',
			'height'            => '860',
			'height_m'            => '400px',
			'padding_top_desk'		=> '270px',
			'padding_top_mobile' => '80px',
			'bg_overlay'		=> 'rgba(0, 0, 0, 0.65)',
			'class'             => '',
		), $atts );

	$html = '<div 
	id="main-slider" 
	data-slider-width="'.$atts['width'].'" 
	data-slider-height="'.$atts['height'].'" 
	data-slider-arrows="'.$atts['dis_arrows'].'" 
	data-slider-buttons="'.$atts['dis_buttons'].'" 
	data-slider-autoplay="'.$atts['autoplay'].'" 
	data-slideAnimationDuration="'.$atts['time_next'].'" 
	class="main-slider slider-pro ' . $atts['class'] . '">
	<div class="sp-slides">' . do_shortcode( $content ) . '</div>
	</div>';

	$html .= '<style>.main-slider__info{ padding-top: ' . $atts['padding_top_desk'] . ' } @media(max-width: 767px){ .main-slider__info{ padding-top: ' . $atts['padding_top_mobile'] . ' } .main-slider { height: '.$atts['height_m'].'; } } .sp-image-container:after{ background-color: '.$atts['bg_overlay'].'; } </style>';

	return $html;
}
