<?php
add_action( 'init', 'vc_dvents_skill', 1000 );
function vc_dvents_skill() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Skill", 'ova-dvents' ),
			"base"     => "dvents_skill",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Value", 'ova-dvents' ),
					"param_name" => "value",
					"value"      => "0"
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),


			)
		) );

	}
}

add_shortcode( 'dvents_skill', 'dvents_skill' );
function dvents_skill( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'title' => '',
			'value' => '0',
			'class' => '',
		), $atts );

	$html = '
		 <div class="progress-block '.$atts['class'].'">
          <div class="progress__title">'.$atts['title'].'</div>
          <div class="progress progress-w-number">
            <div style="width: '.$atts['value'].'%" class="progress-bar bg-primary"><span class="progress-bar__number">'.$atts['value'].'%</span></div>
          </div>
        </div>
	';

	return $html;
}
