<?php
add_action( 'init', 'vc_dvents_services_item', 1000 );
function vc_dvents_services_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Services item", 'ova-dvents' ),
			"base"     => "dvents_services_item",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(
				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Link title", 'ova-dvents' ),
					"param_name" => "link_title",
					"value"      => ""
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Description", 'ova-dvents' ),
					"param_name" => "des",
					"value"      => ""
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Vertical Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Popup Image", 'ova-dvents' ),
					"param_name" => "show_pop_img",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_services_item', 'dvents_services_item' );
function dvents_services_item( $atts, $content = null ) {
	$atts  = shortcode_atts(
		array(
			'image'      => '',
			'title'      => '',
			'des'        => '',
			'link_title' => '',
			'show_line'  => 'true',
			'show_pop_img'	=> 'true',
			'class'      => '',
		), $atts );
	
	$image = '';

	if ( $atts['image'] != '' ) {
		$src   = wp_get_attachment_image_src( $atts['image'], 'full', true );
		if( $atts['show_pop_img'] == 'true' ){
			$image = '<div class="entry-media"><a href="' . $src[0] . '" class="js-zoom-images"><img src="' . $src[0] . '" alt="' . $atts['title'] . '" class="img-responsive"/></a></div>';
		}else{
			$image = '<div class="entry-media"><img src="' . $src[0] . '" alt="' . $atts['title'] . '" class="img-responsive"/></div>';
		}
		
	}

	$html = '
		<section class="b-post-sm b-post-sm-1  clearfix '.$atts['class'].'">
             	 ' . $image . '     
                  <div class="entry-main">
                    <div class="entry-header">';

                      $html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 ui-decor-2_vert bg-primary"></div>' : '<div style="height:30px;"></div>';

	                      if( $atts['link_title'] ){
	                      	$html .= '<h2 class="entry-title entry-title_spacing ui-title-inner"><a href="' . $atts['link_title'] . '">'.$atts['title'].'</a></h2>';	
	                      }else{
	                      	$html .= '<h2 class="entry-title entry-title_spacing ui-title-inner">'.$atts['title'].'</h2>';
	                      }

                    $html .= '</div>';

                    $html .= $atts['des'] ? '<div class="entry-content">
                      <p>' . $atts['des'] . '</p>
                    </div>' : '';

                  $html .= '</div>
         </section>
	';
	return $html;
}
