<?php
add_action( 'init', 'vc_dvents_service_v2', 1000 );
function vc_dvents_service_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Service v2", 'ova-dvents' ),
			"base"                    => "dvents_service_v2",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_service_item_v2' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Display Pager", 'ova-dvents' ),
					"param_name" => "dis_buttons",
					"value"      => array(
						__( 'False', 'ova-dvents' ) => "false",
						__( 'True', 'ova-dvents' )  => "true",

					),
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Autoplay", 'ova-dvents' ),
					"param_name" => "autoplay",
					"value"      => array(
						__( 'False', 'ova-dvents' ) => "false",
						__( 'True', 'ova-dvents' )  => "true",

					),
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Items per page", 'ova-dvents' ),
					"param_name" => "item_per_page",
					"value"      => '3'
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '500'
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_service_v2 extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_service_v2', 'dvents_service_v2' );
function dvents_service_v2( $atts, $content = null ) {

	$atts = shortcode_atts(
		array(
			'dis_buttons' => 'false',
			'autoplay'    => 'false',
			'time_next'   => '500',
			'item_per_page'   => '3',
			'show_line'	=> 'true',
			'class'       => '',
		), $atts );
	$atts['dis_buttons']      = $atts['dis_buttons'] == 'true' ? 'true' : 'false';
	$atts['autoplay'] = $atts['autoplay'] == 'true' ? 'true' : 'false';
	$html = '<div data-slides = '.$atts['item_per_page'].' data-button = "'.$atts['dis_buttons'].'" data-autoplay = "'.$atts['autoplay'].'" data-time-next = "'.$atts['time_next'].'" class="bxslider ' . $atts['class'] . ' "  >' . do_shortcode( $content ) . '</div>';

	if( $atts['show_line'] == 'false' ){
    	$html .= '<style>.b-advantages-2_light .b-advantages-2__title:before{ background: transparent; }</style>';
    }                  	 

	return $html;
}
