<?php
add_action( 'init', 'vc_dvents_service_item_v2', 1000 );
function vc_dvents_service_item_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Service item v2", 'ova-dvents' ),
			"base"     => "dvents_service_item_v2",
			"as_child" => array( 'only' => 'dvents_service_v2' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(



				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"value"      => array(
						__( 'Firework', 'ova-dvents' )   => "flaticon-firework",
						__( 'Food', 'ova-dvents' )       => "flaticon-food",
						__( 'Garlands', 'ova-dvents' )   => "flaticon-garlands",
						__( 'Karaoke', 'ova-dvents' )    => "flaticon-karaoke",
						__( 'People', 'ova-dvents' )     => "flaticon-people",
						__( 'Technology', 'ova-dvents' ) => "flaticon-technology",
					),
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Insert Extra Icon if you doen't want to use above icon", 'ova-dvents' ),
					"param_name" => "extra_icon",
					"default"    => '',
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"default"    => '',
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Description", 'ova-dvents' ),
					"param_name" => "des",
					"default"    => '',
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_service_item_v2 extends WPBakeryShortCode {
			}
		}


	}
}


add_shortcode( 'dvents_service_item_v2', 'dvents_service_item_v2' );
function dvents_service_item_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'des'   => '',
			'title' => '',
			'icon'  => '',
			'extra_icon'	=> '',
			'class' => '',
		), $atts );

	$icon = '';
	if( $atts['extra_icon'] != '' ){
		$icon = '<i class="b-advantages-2__icon ' . $atts['extra_icon'] . '"></i>';
	}else{
		$icon = ( $atts['icon'] != '' ) ? '<i class="b-advantages-2__icon ' . $atts['icon'] . '"></i>' : '';	
	}
	

	$html = '<section class="b-advantages-2 b-advantages-2_light">' . $icon . '
                <div class="b-advantages-2__inner">
                  <h3 class="b-advantages-2__title ui-title-inner bg-primary_b">' . $atts['title'] . '</h3>
                  <div class="b-advantages-2__info">' . $atts['des'] . '</div>
                </div>
             </section>';

	return $html;
}
