<?php
add_action( 'init', 'vc_dvents_reviews_item', 1000 );
function vc_dvents_reviews_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Reviews item", 'ova-dvents' ),
			"base"     => "dvents_reviews_item",
			"as_child" => array( 'only' => 'dvents_review' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Avatar", 'ova-dvents' ),
					"param_name" => "avatar",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Name", 'ova-dvents' ),
					"param_name" => "name",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Address", 'ova-dvents' ),
					"param_name" => "address",
					"value"      => ""
				),

				array(
					"type"       => "textarea_html",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Content", 'ova-dvents' ),
					"param_name" => "content",
					"value"      => ""
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Style", 'ova-dvents' ),
					"param_name" => "style",
					"value"      => array(
						__( 'White', 'ova-dvents' ) => "b-blockquote-3_w_bg",
						__( 'Dark', 'ova-dvents' )  => "none",
					),
				),

				

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_reviews_item extends WPBakeryShortCode {
			}
		}


	}
}


add_shortcode( 'dvents_reviews_item', 'dvents_reviews_item' );
function dvents_reviews_item( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'avatar'  => '',
			'name'    => '',
			'address' => '',
			'class'   => '',
			'style'   => 'b-blockquote-3_w_bg',
		), $atts );
	$src = wp_get_attachment_image_src($atts['avatar'], 'full' );
	$html = '<blockquote class="b-blockquote b-blockquote-3 '. $atts['style'] .' '.$atts['class'].'">
                    <p>' . do_shortcode( $content ) . '</p>
                    <footer class="b-blockquote__footer">
                      <div class="b-blockquote__face"><img src="'.$src[0].'" alt="'.$atts['name'].'" class="img-responsive"/></div>
                      <cite title="Blockquote Title" class="b-blockquote__cite">
	                      <span class="b-blockquote__author">' . $atts['name'] . '</span>
	                      <span class="b-blockquote__category">' . $atts['address'] . '</span>
                      </cite>
                    </footer>
                  </blockquote>';

    

	return $html;
}
