<?php
add_action( 'init', 'vc_dvents_reviews', 1000 );
function vc_dvents_reviews() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Reviews", 'ova-dvents' ),
			"base"                    => "dvents_reviews",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_reviews_item' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '7000'
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show dot", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => false,
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => false,
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_reviews extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_reviews', 'dvents_reviews' );
function dvents_reviews( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'time_next' => '7000',
			'show_dot' => false,
			'stop_on_hover' => false,
			'show_line'	=> 'true',
			'class'    => '',
		), $atts );

	$atts['show_dot']      = $atts['show_dot'] == true ? 'true' : 'false';
	$atts['stop_on_hover'] = $atts['stop_on_hover'] == true ? 'true' : 'false';

	$html = '<div class="area-bg__inner '.$atts['class'].'">
          <div class="container">
            <div class="row">
              <div class="col-sm-11"><div data-pagination="'.$atts['show_dot'].'" data-navigation="false" data-single-item="true" data-auto-play="'.$atts['time_next'].'" data-transition-style="fade" data-main-text-animation="true" data-after-init-delay="3000" data-after-move-delay="1000" data-stop-on-hover="'.$atts['stop_on_hover'].'" class="owl-carousel owl-theme owl-theme_mod-a enable-owl-carousel ">'.do_shortcode($content).'</div></div></div></div></div>';

    if( $atts['show_line'] == 'false' ){
    	$html .= '<style>.b-blockquote-3:before, .b-blockquote-3_w_bg:before{ background: transparent; }</style>';
    }          

	return $html;
}
