<?php
add_action( 'init', 'vc_dvents_progress_v2', 1000 );
function vc_dvents_progress_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Progress v2", 'ova-dvents' ),
			"base"                    => "dvents_progress_v2",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_progress_item_v2' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_progress_v2 extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_progress_v2', 'dvents_progress_v2' );
function dvents_progress_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'show_line'	=> 'true',
			'class'    => '',
		), $atts );
	$html = '<div class="section-progress section-progress_mod-b '.$atts['class'].'" >
          		<ul class="b-progress-list b-progress-list_mod-a list-unstyled">'.do_shortcode($content).'</ul>
          	 </div>';

    if( $atts['show_line'] == 'false' ){
    	$html .= '<style>.b-progress-list_mod-a .b-progress-list__name:before{ background: transparent; }</style>';
    }                  	 

	return $html;
}
