<?php
add_action( 'init', 'vc_dvents_progress_item_v2', 1000 );
function vc_dvents_progress_item_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Process item 2", 'ova-dvents' ),
			"base"     => "dvents_progress_item_v2",
			"as_child" => array( 'only' => 'dvents_progress_v2' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => "",
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"value"      => "",
					"description" => esc_html__( "For example: icon-puzzle. Find here: http://simplelineicons.com/", 'ova-dvents' )
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Number", 'ova-dvents' ),
					"param_name" => "number",
					"value"      => "0"
				),
				
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_progress_item_v2 extends WPBakeryShortCode {
			}
		}


	}
}


add_shortcode( 'dvents_progress_item_v2', 'dvents_progress_item_v2' );
function dvents_progress_item_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'title'  => '',
			'icon'  => '',
			'number' => 0,
			'class'  => '',
		), $atts );
	$html = '<li class="b-progress-list__item clearfix">
                  <div class="b-progress-list__inner">
                    <div class="b-progress-list__label"></div>
                    <span data-percent="'.$atts['number'].'" class="b-progress-list__percent js-chart">
                    	<span class="js-percent"></span>
                    </span>
                    <span class="b-progress-list__name">'.$atts['title'].'</span>
                  </div>
                  <div class="b-progress-list__icon text-primary '.$atts['icon'].'"></div>
                </li>';

	return $html;
}
