<?php
add_action( 'init', 'vc_dvents_progress', 1000 );
function vc_dvents_progress() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Progress", 'ova-dvents' ),
			"base"                    => "dvents_progress",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_progress_item' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_progress extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_progress', 'dvents_progress' );
function dvents_progress( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'class'    => '',
		), $atts );
	$html = ' <div class="area-bg__inner '.$atts['class'].'">
          			<ul class="b-progress-list b-progress-list_no-icon list-unstyled clearfix">'.do_shortcode($content).'</ul>
          		</div> ';

	return $html;
}
