<?php
add_action( 'init', 'vc_dvents_pricing', 1000 );
function vc_dvents_pricing() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Pricing", 'ova-dvents' ),
			"base"     => "dvents_pricing",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Text price", 'ova-dvents' ),
					"param_name" => "text_price",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Price unit", 'ova-dvents' ),
					"param_name" => "price_unit",
					"value"      => ""
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Unit position", 'ova-dvents' ),
					"param_name" => "unit_position",
					"value"      => array(
						__( 'After', 'ova-dvents' )  => "after",
						__( 'Before', 'ova-dvents' ) => "before",
					)
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Price", 'ova-dvents' ),
					"param_name" => "price",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_stitle",
					"value"      => ""
				),


				array(
					"type"       => "textarea_raw_html",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Description", 'ova-dvents' ),
					"param_name" => "descrition",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button text", 'ova-dvents' ),
					"param_name" => "button_text",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button link", 'ova-dvents' ),
					"param_name" => "button_link",
					"value"      => ""
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Open in link new tab", 'ova-dvents' ),
					"param_name" => "target",
					"value"      => false,
				),


				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Active", 'ova-dvents' ),
					"param_name" => "active",
					"value"      => array(
						__( 'Deactive', 'ova-dvents' ) => "deactive",
						__( 'Active', 'ova-dvents' )   => "active",
					)
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),

			)
		) );

	}
}


add_shortcode( 'dvents_pricing', 'dvents_pricing' );

function dvents_pricing( $atts, $content = null ) {
	$atts       = shortcode_atts(
		array(
			'text_price'    => '',
			'price_unit'    => '',
			'price'         => '',
			'title'         => '',
			'sub_stitle'    => '',
			'button_text'   => '',
			'button_link'   => '',
			'descrition'    => '',
			'active'        => '',
			'unit_position' => 'after',
			'target'        => false,
			'class'         => '',
		), $atts );
	$target = ($atts['target'] == true)?'target = "_blank"':'';
	$title      = ( $atts['title'] != '' ) ? '<h3 class="b-pricing__title">' . $atts['title'] . '</h3>' : '';
	$sub_stitle = ( $atts['sub_stitle'] != '' ) ? '<div class="b-pricing__subtitle">' . $atts['sub_stitle'] . '</div>' : '';
	$text_price = ( $atts['text_price'] != '' ) ? '<span class="b-pricing-price__title">' . $atts['text_price'] . '</span>' : '';
	$button     = ( $atts['button_text'] != '' ) ? '<a '.$target.' href="' . $atts['button_link'] . '" class="b-pricing__btn btn btn-default">' . $atts['button_text'] . '</a>' : '';
	$price      = '';
	$active     = ( $atts['active'] == 'active' ) ? '<div class="b-pricing__icon bg-primary"><i class="icon fa fa-heart"></i></div>' : '';
	if ( $atts['price'] != '' ) {
		if ( $atts['unit_position'] == 'after' ) {
			$price = '<div class="b-pricing-price ">' . $text_price . '<span class="b-pricing-price__number">' . $atts['price'] . '</span>' . $atts['price_unit'] . '</div>';
		} else {
			$price = '<div class="b-pricing-price ">' . $text_price . $atts['price_unit'] . '<span class="b-pricing-price__number">' . $atts['price'] . '</span></div>';
		}

	}
	$html = '
			<section class="b-pricing ' . $atts['active'] . ' ' . $atts['class'] . '">
                ' . $title . $sub_stitle . $price . $active . rawurldecode( base64_decode( $atts['descrition'] ) ) . $button . '
            </section>
	';

	return $html;
}
