<?php
add_action( 'init', 'vc_dvents_info_image', 1000 );
function vc_dvents_info_image() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Info image", 'ova-dvents' ),
			"base"     => "dvents_info_image",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(


				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image1", 'ova-dvents' ),
					"param_name" => "image1",
					"value"      => ""
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image 2", 'ova-dvents' ),
					"param_name" => "image2",
					"value"      => ""
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),


			)
		) );

	}
}

add_shortcode( 'dvents_info_image', 'dvents_info_image' );
function dvents_info_image( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'image1' => '',
			'image2' => '',
			'class'  => '',
		), $atts );
	$src = wp_get_attachment_image_src($atts['image1'],'full');
	$image1 = ($atts['image1']!='')?'<img src="'.$src[0].'" alt="'.__('Info image 1','ova-dvents').'" class="b-info-section__img-1 img-mask"/>':'';
	$src = wp_get_attachment_image_src($atts['image2'],'full');
	$image2 = ($atts['image1']!='')?'<img src="'.$src[0].'" alt="'.__('Info image 2','ova-dvents').'" class="b-info-section__img-2 img-mask"/>':'';
	$html = '
          <div class="row">
            <div class="col-sm-6">'.$image1.'</div>
            <div class="col-sm-6">'.$image2.'</div>
          </div>
	';

	return $html;
}
