<?php
add_action( 'init', 'vc_dvents_heading_v3', 1000 );
function vc_dvents_heading_v3() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Heading v3", 'ova-dvents' ),
			"base"     => "dvents_heading_v3",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

			)
		) );

	}
}


add_shortcode( 'dvents_heading_v3', 'dvents_heading_v3' );
function dvents_heading_v3( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'title'    => '',
			'image'          => '',
			'center'         => false,
			'normal_before'         => false,
		), $atts );
	$icon = '';
	if ($atts['image']!='') {
		$src = wp_get_attachment_image_src( $atts['image'], 'full', true );
		$icon = '<div class="ui-decor-1"><img src="'.$src[0].'" alt="decor" class="center-block"></div>';
	}
	$html =  $icon.'
              <div class="text-center">
                <h2 class="b-contact__title ui-subtitle-block">'.$atts['title'].'</h2>
              </div>';
	return $html;
}
