<?php
add_action( 'init', 'vc_dvents_heading_v2', 1000 );
function vc_dvents_heading_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Heading v2", 'ova-dvents' ),
			"base"     => "dvents_heading_v2",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text 1", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),




				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Highlight text", 'ova-dvents' ),
					"param_name" => "highlight_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text 2", 'ova-dvents' ),
					"param_name" => "normal_text_2",
					"value"      => ""
				),



				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Subtext text", 'ova-dvents' ),
					"param_name" => "sub_text",
					"value"      => ""
				),

			)
		) );

	}
}


add_shortcode( 'dvents_heading_v2', 'dvents_heading_v2' );
function dvents_heading_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'normal_text'    => '',
			'highlight_text' => '',
			'normal_text_2' => '',
			'sub_text'       => '',
			'image'          => '',
			'center'         => false,
			'normal_before'         => false,
		), $atts );


	$title = '';
	if ($atts['normal_text']!=''  || $atts['normal_text_2']!='' || $atts['highlight_text'] !='') {
		$title = '<h2 class="ui-title-block ui-title-block_weight_normal"> '.$atts['normal_text'].' <span class="text-primary"> '.$atts['highlight_text'].' </span> '.$atts['normal_text_2'].' </h2>';
	}

	$icon = '';
	if ($atts['image']!='') {
		$src = wp_get_attachment_image_src( $atts['image'], 'full', true );
		$icon = '<div class="ui-decor-1"><img src="'.$src[0].'" alt="decor" class="center-block"></div>';
	}
	$html = $icon .
	        '<div class="text-center">
				'.$title.'
                <div class="ui-subtitle-block">' . $atts['sub_text'] . '</div>
            </div>';
	return $html;
}
