<?php
add_action( 'init', 'vc_dvents_heading', 1000 );
function vc_dvents_heading() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Heading", 'ova-dvents' ),
			"base"     => "dvents_heading",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),




				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Highlight text", 'ova-dvents' ),
					"param_name" => "highlight_text",
					"value"      => ""
				),
				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Text normal bold ?", 'ova-dvents' ),
					"param_name" => "normal_bold",
					"default"    => false
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Text normal before Text highlight ?", 'ova-dvents' ),
					"param_name" => "normal_before",
					"default"    => false
				),


				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Subtext text", 'ova-dvents' ),
					"param_name" => "sub_text",
					"value"      => ""
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Align center?", 'ova-dvents' ),
					"param_name" => "center",
					"default"    => false
				),

			)
		) );

	}
}


add_shortcode( 'dvents_heading', 'dvents_heading' );
function dvents_heading( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'normal_text'    => '',
			'highlight_text' => '',
			'sub_text'       => '',
			'image'          => '',
			'center'         => false,
			'normal_before'         => false,
			'normal_bold'         => false,
		), $atts );


	$title = '';
	if ($atts['normal_text']!='' || $atts['highlight_text'] !='') {
		if ( $atts['normal_before'] == true ) {
			$title = '<h2 class="ui-title-block ui-title-block_lg">' . $atts['normal_text'] . '<span class="text-primary"> ' . $atts['highlight_text'] . '</span></h2>';
			if ($atts['normal_bold'] == true){
				$title = '<h2 class="ui-title-block">' . $atts['normal_text'] . '<span class="text-primary"> ' . $atts['highlight_text'] . '</span></h2>';
			}
		} else {
			$title = '<h2 class="ui-title-block"><span class="text-primary">' . $atts['highlight_text'] . '</span> ' . $atts['normal_text'] . '</h2>';
		}
	}
	if ($atts['center'] == true)  {

		$icon = '';
		if ($atts['image']!='') {
			$src = wp_get_attachment_image_src( $atts['image'], 'full', true );
			$icon = '<div class="ui-decor-1"><img src="'.$src[0].'" alt="decor" class="center-block"></div>';
		}

		$html = $icon .
		        '<div class="text-center">
					'.$title.'
                	<div class="ui-subtitle-block">' . $atts['sub_text'] . '</div>
              	</div>';
	}else{

		$icon = '';
		if ($atts['image']!='') {
			$src = wp_get_attachment_image_src( $atts['image'], 'full', true );
			$icon = '<div class="ui-decor-1"><img src="'.$src[0].'" alt="'.$atts['highlight_text'].$atts['normal_text'].'" ></div>';
		}

		$html = $icon. $title.'<div class="ui-subtitle-block">' . $atts['sub_text'] . '</div>';
	}
	return $html;
}
