<?php
add_action( 'init', 'vc_dvents_gallery', 1000 );
function vc_dvents_gallery() {
	if ( function_exists( 'vc_map' ) ) {
		$term      = get_terms( 'gallerygroup' );
		$termsSlug = array();
		foreach ( $term as $item ) {
			$termsSlug[] = $item->slug;
		}

		vc_map( array(
			"name"     => __( "Gallery", 'ova-dvents' ),
			"base"     => "dvents_gallery",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Grallery Groups", 'ova-dvents' ),
					"param_name" => "groups",
					"value"      => implode( ',', $termsSlug )
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => "8"
				),


				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Order", 'ova-dvents' ),
					"param_name" => "order",
					"value"      => array(
						__( 'ASC', 'ova-dvents' )  => "ASC",
						__( 'DESC', 'ova-dvents' ) => "DESC",
					),
					"default"    => "ASC"
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Text bottom", 'ova-dvents' ),
					"param_name" => "text_bottom",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button text ", 'ova-dvents' ),
					"param_name" => "button_text",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button link ", 'ova-dvents' ),
					"param_name" => "button_link",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Text all group ", 'ova-dvents' ),
					"param_name" => "all_group",
					"value"      => ""
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_gallery', 'dvents_gallery' );
function dvents_gallery( $atts, $content = null ) {

	$term      = get_terms( 'gallerygroup' );
	$termsSlug = array();
	foreach ( $term as $item ) {
		$termsSlug[] = $item->slug;
	}

	$atts       = shortcode_atts(
		array(
			'groups'      => implode(',',$termsSlug),
			'limit'       => '8',
			'order'       => 'ASC',
			'text_bottom' => '',
			'button_text' => '',
			'button_link' => '',
			'all_group'   => '',
			'class'       => '',
		), $atts );
	$groups     = explode( ',', $atts['groups'] );
	$listgroups = array();
	$groupIDs   = array();
	$listabs    = array();
	foreach ( $groups as $group ) {
		$term         = get_term_by( 'slug', $group, 'gallerygroup' );
		$listgroups[] = $term;
		$groupIDs[]   = $term->term_id;
		$listabs[]    = '<li><a href="" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
	}




	$args = array(
		'post_type'   => 'gallery',
		'tax_query'   => array(
			array(
				'taxonomy' => 'gallerygroup',
				'field'    => 'term_id',
				'terms'    => $groupIDs,
				'operator' => 'IN',
			)

		),
		'post_status' => array( 'publish' ),
		'meta_key'    => 'dvents_met_gallery_order',
		'orderby'     => 'meta_value_num',
		'order'       => $atts['order'],
		'posts_per_page' => $atts['limit']
	);


	$query = new WP_Query( $args );


	$button      = $atts['button_text'] != '' ? '<a href="" class="b-isotope__btn btn btn-primary">' . $atts['button_text'] . '</a>' : '';
	$text_bottom = $atts['text_bottom'] != '' ? '<span class="b-isotope__info">' . $atts['text_bottom'] . '</span>' : '';

	$html = '<div class="b-isotope ">
			          <div class="container">
			            <div class="row">
			              <div class="col-xs-12">
			                <ul class="b-isotope-filter list-inline">
			                  <li><a href="" data-filter="*" class="current">'.$atts['all_group'].'</a></li>
			                  ' . (implode( '', $listabs )) . '
			                </ul>
			              </div>
			            </div>
			          </div>
		          <ul class="b-isotope-grid grid list-unstyled js-zoom-gallery">
			            <li class="grid-sizer"></li>';

	while ( $query->have_posts() ) {
		$query->the_post();
		$gallery_terms = wp_get_post_terms( get_the_ID(),'gallerygroup' );
		$listterms     = array();
		$listtermstext     = array();
		foreach ( $gallery_terms as $gallery_term ) {
			$listterms[]     = $gallery_term->slug;
			$listtermstext[] = $gallery_term->name;
		}
		$src  = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );
		$html .= '	    <li class="b-isotope-grid__item grid-item ' . ( implode( ' ', $listterms ) ) . '">
			            <a href="' . $src[0] . '" class="b-isotope-grid__inner js-zoom-gallery__item">
				            <img src="' . $src[0] . '" alt="foto"/>
				            <span class="b-isotope-grid__wrap-info">
					            <span class="b-isotope-grid__info">
					                <span class="b-isotope-grid__title">' . get_the_title() . '</span>
				                    <span class="b-isotope-grid__categorie">' . ( implode( ', ', $listtermstext ) ) . '</span>
				                </span>
				                <i class="icon icon-magnifier-add text-primary"></i>
			                </span>
			            </a>
		            </li>';
	}
	$html .= '       </ul>
        	</div>
        	<div class="text-center">' . $text_bottom . $button . '</div>';
	wp_reset_query();
	return $html;
}
