<?php
add_action( 'init', 'vc_dvents_event_v2', 1000 );
function vc_dvents_event_v2() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"        => __( "Event 2", 'ova-dvents' ),
			"base"        => "dvents_event_v2",
			"class"       => "",
			"category"    => __( "Dvents", 'ova-dvents' ),
			"icon"        => "icon-qk",
			"description" => __( "Slider", 'ovan-dvents' ),
			"params"      => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => '10',
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Order by", 'ova-dvents' ),
					"param_name" => "order_by",
					"value"      => array(
						__( 'Start time', 'ova-dvents' ) => "dvents_met_event_start_time",
						__( 'Order', 'ova-dvents' )      => "dvents_met_event_order",
					),
					"default"    => "dvents_met_event_start_time"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Order", 'ova-dvents' ),
					"param_name" => "order",
					"value"      => array(
						__( 'ASC', 'ova-dvents' )  => "ASC",
						__( 'DESC', 'ova-dvents' ) => "DESC",
					),
					"default"    => "ASC"
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show dot", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => true,
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => true,
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '7000'
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Text more info", 'ova-dvents' ),
					"param_name" => "more_info_text",
					"value"      => ''
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Vertical Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Address", 'ova-dvents' ),
					"param_name" => "show_address",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show Past Event", 'ova-dvents' ),
					"param_name" => "show_past",
					"value"      => array(
						__( 'Yes', 'ova-dvents' )  => "true",
						__( 'No', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_event_v2', 'dvents_event_v2' );
function dvents_event_v2( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'limit'          => '10',
			'order'          => 'ASC',
			'stop_on_hover'  => true,
			'show_dot'       => true,
			'time_next'      => '7000',
			'more_info_text' => '',
			'order_by'       => 'dvents_met_event_start_time',
			'show_line'	=> 'true',
			'show_address'	=> 'true',
			'show_past' => 'true',
			'class'          => '',
		), $atts );


	$args_basic = array(
		'post_type'      => 'event',
		'post_status'    => array( 'publish' ),
		'meta_key'       => $atts['order_by'],
		'orderby'        => 'meta_value_num',
		'order'          => $atts['order'],
		'posts_per_page' => $atts['limit']
	);

	$args_past = $args = array();

	if( $atts['show_past'] == 'false' ){
		$args_past = array(
			'meta_query' => array(
				array(
					'key' => 'dvents_met_event_start_time',
					'value' => current_time( 'timestamp' ),
					'compare' => '>'
				)
			)
		);
	}
	
	$args = array_merge($args_basic, $args_past);

	$query                 = new WP_Query( $args );
	$atts['show_dot']      = $atts['show_dot'] == true ? 'true' : 'false';
	$atts['stop_on_hover'] = $atts['stop_on_hover'] == true ? 'true' : 'false';


	$html = '
	 <div 
	 style = "padding-bottom: 60px"
	 data-min480="1" 
	 data-min768="3" 
	 data-min992="4" 
	 data-min1200="4" 
	 data-pagination="' . $atts['show_dot'] . '" 
	 data-navigation="false" 
	 data-auto-play="' . $atts['time_next'] . '" 
	 data-stop-on-hover="' . $atts['stop_on_hover'] . '" 
	 class="owl-carousel owl-theme enable-owl-carousel ' . $atts['class'] . '">';


	while ( $query->have_posts() ) {
		$query->the_post();
		$src        = get_post_meta(get_the_ID(),'dvents_met_featured_image',true);
		$time_start = get_post_meta( get_the_ID(), 'dvents_met_event_start_time', true );


		$time = $time_start - time();

		$textds = __( 'days', 'ova-dvents' );
		$textd  = __( 'day', 'ova-dvents' );
		$texths = __( 'hours', 'ova-dvents' );
		$texth  = __( 'hour', 'ova-dvents' );
		$textms = __( 'mins', 'ova-dvents' );
		$textm  = __( 'min', 'ova-dvents' );
		$textss = __( 'secs', 'ova-dvents' );
		$texts  = __( 'sec', 'ova-dvents' );


		$days      = floor( $time / ( 60 * 60 * 24 ) );
		$days_text = ( $days > 1 ) ? $textds : $textd;

		$hours      = floor( ( $time - $days * ( 60 * 60 * 24 ) ) / ( 60 * 60 ) );
		$hours_text = ( $hours > 1 ) ? $texths : $texth;

		$mins      = floor( ( $time - $days * ( 60 * 60 * 24 ) - $hours * 60 * 60 ) / 60 );
		$mins_text = ( $mins > 1 ) ? $textms : $textm;

		$secs      = floor( ( $time - $days * ( 60 * 60 * 24 ) - $hours * 60 * 60 - $mins * 60 ) );
		$secs_text = ( $secs > 1 ) ? $textss : $texts;

		$style = '';
		if ( $days < 0 || $hours < 0 || $secs < 0 || $mins < 0 ) {
			$style = 'display:none';
		}
		$html .= '
				<section class="b-events-2 text-center">
                  <div class="b-events-2__media"><img src="' . $src . '" alt="' . get_the_title() . '" class="img-responsive image-event-2"/>
                    <div class="b-events-calendar" style="' . $style . '" 
                            
                            data-ds = "' . $textds . '" 
	                        data-d = "' . $textd . '" 
	                        data-hs = "' . $texths . '" 
	                        data-h = "' . $texth . '" 
	                        data-ms = "' . $textms . '" 
	                        data-m = "' . $textm . '" 
	                        data-ss = "' . $textss . '" 
	                        data-s = "' . $texts . '" 
	                        
                    
                    data-start = "' . $time_start . '" data-curent-time = "' . time() . '">
                      <div class="b-events-calendar__wrap" >
                        
                        	  <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__days">' . $days . '</span>
	                          	<span class="b-events-calendar__title calendar__text__days">' . $days_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__hours">' . $hours . '</span>
	                          	<span class="b-events-calendar__title calendar__text__hours">' . $hours_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__mins">' . $mins . '</span>
	                          	<span class="b-events-calendar__title calendar__text__mins">' . $mins_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__secs">' . $secs . '</span>
	                          	<span class="b-events-calendar__title calendar__text__secs">' . $secs_text . '</span>
	                          </div>
	                          
                      </div>
                    </div>
                  </div>';
                  
                  $html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 ui-decor-2_vert bg-primary"></div>' : '<div style="height: 38px;"></div>';

                  $html .= '<h3 class="b-events-2__title"><a href="' . get_the_permalink( get_the_ID() ) . '">' . get_the_title() . '</a></h3>';
                  $html .= $atts['show_address'] == 'true' ? '<div class="b-events__details"><i class="icon icon-map"></i> ' . get_post_meta( get_the_ID(), 'dvents_met_event_address', true ) . '</div>' : '';
                $html .= '</section>
		';

	}


	$html .= '</div>';
	wp_reset_query();

	return $html;
}
