<?php
add_action( 'init', 'vc_dvents_event', 1000 );
function vc_dvents_event() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"        => __( "Event 1", 'ova-dvents' ),
			"base"        => "dvents_event",
			"class"       => "",
			"category"    => __( "Dvents", 'ova-dvents' ),
			"icon"        => "icon-qk",
			"description" => __( "Slider", 'ovan-dvents' ),
			"params"      => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => '10',
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Order by", 'ova-dvents' ),
					"param_name" => "order_by",
					"value"      => array(
						__( 'Start time', 'ova-dvents' ) => "dvents_met_event_start_time",
						__( 'Order', 'ova-dvents' )      => "dvents_met_event_order",
					),
					"default"    => "dvents_met_event_start_time"
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Order", 'ova-dvents' ),
					"param_name" => "order",
					"value"      => array(
						__( 'ASC', 'ova-dvents' )  => "ASC",
						__( 'DESC', 'ova-dvents' ) => "DESC",
					),
					"default"    => "ASC"
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show dot", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => false
				),

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show Past Event", 'ova-dvents' ),
					"param_name" => "show_past",
					"value"      => array(
						__( 'Yes', 'ova-dvents' )  => "true",
						__( 'No', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				
				
				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => false,
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '7000'
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Text more info", 'ova-dvents' ),
					"param_name" => "more_info_text",
					"value"      => ''
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Vertical Line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Address", 'ova-dvents' ),
					"param_name" => "show_address",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Time", 'ova-dvents' ),
					"param_name" => "show_time",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_event', 'dvents_event' );
function dvents_event( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'limit'          => '10',
			'order'          => 'ASC',
			'stop_on_hover'  => false,
			'show_dot'       => false,
			'time_next'      => '7000',
			'order_by'       => 'dvents_met_event_start_time',
			'more_info_text' => '',
			'show_line'	=> 'true',
			'show_address'	=> 'true',
			'show_time'	=> 'true',
			'show_past' => 'true',
			'class'          => '',
		), $atts );


	$args_basic = array(
		'post_type'      => 'event',
		'post_status'    => array( 'publish' ),
		'meta_key'       => $atts['order_by'],
		'orderby'        => 'meta_value_num',
		'order'          => $atts['order'],
		'posts_per_page' => $atts['limit']
	);

	$args_past = $args = array();

	if( $atts['show_past'] == 'false' ){
		$args_past = array(
			'meta_query' => array(
				array(
					'key' => 'dvents_met_event_start_time',
					'value' => current_time( 'timestamp' ),
					'compare' => '>'
				)
			)
		);
	}
	
	$args = array_merge($args_basic, $args_past);

	$query                 = new WP_Query( $args );
	$atts['show_dot']      = $atts['show_dot'] == true ? 'true' : 'false';
	$atts['stop_on_hover'] = $atts['stop_on_hover'] == true ? 'true' : 'false';


	$html = '<div 
	data-pagination="' . $atts['show_dot'] . '" 
	data-navigation="false" 
	data-single-item="true" 
	data-auto-play="' . $atts['time_next'] . '" 
	data-transition-style="fade" 
	data-main-text-animation="true" 
	data-after-init-delay="3000" 
	data-after-move-delay="1000" 
	data-stop-on-hover="' . $atts['stop_on_hover'] . '" 
	class="owl-carousel owl-theme enable-owl-carousel ' . $atts['class'] . ' "
	>';


	while ( $query->have_posts() ) {
		$query->the_post();
		$src        = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full', true );
		$time_start = get_post_meta( get_the_ID(), 'dvents_met_event_start_time', true );

		$time_start_text = date( get_option('date_format'), $time_start );
		$hour_start      = date( 'h A', $time_start );
		$time_end        = get_post_meta( get_the_ID(), 'dvents_met_event_end_time', true );
		$hour_end        = date( 'h A', $time_end );
		$time            = $time_start - time();

		$textds = __( 'days', 'ova-dvents' );
		$textd  = __( 'day', 'ova-dvents' );
		$texths = __( 'hours', 'ova-dvents' );
		$texth  = __( 'hour', 'ova-dvents' );
		$textms = __( 'mins', 'ova-dvents' );
		$textm  = __( 'min', 'ova-dvents' );
		$textss = __( 'secs', 'ova-dvents' );
		$texts  = __( 'sec', 'ova-dvents' );


		$days      = floor( $time / ( 60 * 60 * 24 ) );
		$days_text = ( $days > 1 ) ? $textds : $textd;

		$hours      = floor( ( $time - $days * ( 60 * 60 * 24 ) ) / ( 60 * 60 ) );
		$hours_text = ( $hours > 1 ) ? $texths : $texth;

		$mins      = floor( ( $time - $days * ( 60 * 60 * 24 ) - $hours * 60 * 60 ) / 60 );
		$mins_text = ( $mins > 1 ) ? $textms : $textm;

		$secs      = floor( ( $time - $days * ( 60 * 60 * 24 ) - $hours * 60 * 60 - $mins * 60 ) );
		$secs_text = ( $secs > 1 ) ? $textss : $texts;
		$style     = '';
		if ( $days < 0 || $hours < 0 || $secs < 0 || $mins < 0 ) {
			$style = 'display:none';
		}
		$datestart = date('Y-m-d',$time_start);
		$dateend = date('Y-m-d',$time_end);
		if ($datestart ==$dateend) {
			$hourfromto = '  ,  ' . $hour_start . ' ' . __( 'to', 'ova-dvents' ) . ' ' . $hour_end;
		}else{
			$hourfromto = ' '.$hour_start;
		}

		$html .= '<section class="b-events ' . $atts['class'] . '">
	                  <div class="row">
	                    <div class="col-sm-6">

	                      <div class="b-events__media"><img src="' . $src[0] . '" alt="' . get_the_title() . '" class="img-responsive marginauto"/></div>

	                      <div class="text-center">
	                        <div class="b-events-calendar bg-primary" style="' . $style . '" 
	                        data-ds = "' . $textds . '" 
	                        data-d = "' . $textd . '" 
	                        data-hs = "' . $texths . '" 
	                        data-h = "' . $texth . '" 
	                        data-ms = "' . $textms . '" 
	                        data-m = "' . $textm . '" 
	                        data-ss = "' . $textss . '" 
	                        data-s = "' . $texts . '" 
	                        data-start = "' . $time_start . '" 
	                        data-curent-time = "' . time() . '" 
	                        >
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__days">' . $days . '</span>
	                          	<span class="b-events-calendar__title calendar__text__days">' . $days_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__hours">' . $hours . '</span>
	                          	<span class="b-events-calendar__title calendar__text__hours">' . $hours_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__mins">' . $mins . '</span>
	                          	<span class="b-events-calendar__title calendar__text__mins">' . $mins_text . '</span>
	                          </div>
	                          <div class="b-events-calendar__item">
	                          	<span class="b-events-calendar__number calendar__number__secs">' . $secs . '</span>
	                          	<span class="b-events-calendar__title calendar__text__secs">' . $secs_text . '</span>
	                          </div>
	                        </div>
	                      </div>
	                    </div>
	                    
	                    <div class="col-sm-6">
	                      <div class="b-events__inner">';

	                        $html .= '<h3 class="b-events__title">';
	                        	$html .= $atts['show_line'] == 'true' ? '<span class="ui-decor-2 bg-primary"></span>' : '';
	                        	$html .= '<a href="' . get_page_link( get_the_ID() ) . '" >' . get_the_title() . '</a>';
	                        $html .= '</h3>';

	                        $html .= '<p>' . get_the_excerpt() . '</p>';

	                        $html .= $atts['more_info_text'] ? '<h4 class="b-events__subtitle">' . $atts['more_info_text'] . '</h4>' : '';

	                        $html .= $atts['show_address'] == 'true' ? '<div class="b-events__details"><i class="icon icon-map"></i> ' . get_post_meta( get_the_ID(), 'dvents_met_event_address', true ) . '</div>' : '';

	                        $html .= $atts['show_time'] == 'true' ? '<div class="b-events__details"><i class="icon icon-calendar"></i> ' . $time_start_text . $hourfromto . '</div>' : '';

	                      $html .= '</div>
	                    </div>
	                  </div>
            	 </section>';

	}


	$html .= '</div>';
	wp_reset_query();

	return $html;
}
