<?php
add_action( 'init', 'vc_dvents_contact_info', 1000 );
function vc_dvents_contact_info() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Contact info", 'ova-dvents' ),
			"base"     => "dvents_contact_info",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"default"    => '',
					"description" => esc_html__( "For example: icon-puzzle. Find here: http://simplelineicons.com/", 'ova-dvents' )
				),
				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Background image", 'ova-dvents' ),
					"param_name" => "background_image",
					"default"    => '',
				),
				array(
					"type"       => "colorpicker",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Background color", 'ova-dvents' ),
					"param_name" => "background_color",
					"default"    => '',
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"default"    => '',
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Value", 'ova-dvents' ),
					"param_name" => "value",
					"default"    => '',
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_contact_info', 'dvents_contact_info' );
function dvents_contact_info( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'icon'             => '',
			'title'            => '',
			'background_image' => '',
			'background_color' => '',
			'value'            => '',
			'class'            => '',
		), $atts );
	$src = wp_get_attachment_image_src($atts['background_image'],'full');
	$html = '<div 
	data-stellar-background-ratio="0.4" 
	style="background-color: '.$atts['background_color'].'; background-image: url('.$src[0].')" 
	class="b-contact stellar section-texture section-radius '.$atts['class'].'" >
                <div class="b-contact__name">'.$atts['title'].'</div>
                <div class="b-contact__info">'.$atts['value'].'</div>
                <div class="b-contact__icon '.$atts['icon'].'"></div>
              </div>';
	return $html;
}
