<?php
add_action( 'init', 'vc_dvents_contact', 1000 );
function vc_dvents_contact() {
	if ( function_exists( 'vc_map' ) ) {

		$cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

		$contact_forms = array();
		if ( $cf7 ) {
			foreach ( $cf7 as $cform ) {
				$contact_forms[ $cform->post_title ] = $cform->ID;
			}
		}

		vc_map( array(
			"name"     => __( "Contact form", 'ova-dvents' ),
			"base"     => "dvents_contact",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Contact form 7", 'ova-dvents' ),
					"param_name" => "contact_from_7",
					"value"      => $contact_forms,
				),


				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Icon", 'ova-dvents' ),
					"param_name" => "icon",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Highlight text", 'ova-dvents' ),
					"param_name" => "highlight_text",
					"value"      => ""
				),
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image left", 'ova-dvents' ),
					"param_name" => "image_left",
					"value"      => ""
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Contact form align", 'ova-dvents' ),
					"param_name" => "contact_form_align",
					"value"      => array(
						__( 'Right', 'ova-dvents' ) => "right",
						__( 'Left', 'ova-dvents' )  => "left",

					),
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_contact', 'dvents_contact' );
function dvents_contact( $atts, $content = null ) {
	$atts          = shortcode_atts(
		array(
			'sub_title'          => '',
			'contact_from_7'     => '',
			'icon'               => '',
			'normal_text'        => '',
			'highlight_text'     => '',
			'image_left'         => '',
			'contact_form_align' => 'right',
			'class'              => '',
		), $atts );
	$imageleft_src = wp_get_attachment_image_src( $atts['image_left'], 'full' );
	$icon_src      = wp_get_attachment_image_src( $atts['icon'], 'full' );
	if ($atts['contact_form_align'] == 'right') {
		$html = '
		<div class="block-table block-table-md ' . $atts['class'] . '">
        	<div class="block-table__cell col-md-6"><img src="' . $imageleft_src[0] . '" alt="' . $atts['highlight_text'] . ' ' . $atts['sub_title'] . '"></div>
	        <div class="block-table__cell col-md-6">
	          <section data-stellar-background-ratio="0.4" class="section-form-contact section-form-contact_color_white section-texture bg-primary stellar">
	            <div class="ui-decor-1"><img src="' . $icon_src[0] . '" alt="' . $atts['highlight_text'] . ' ' . $atts['sub_title'] . '"></div>
	            <h2 class="ui-title-block"><span>' . $atts['highlight_text'] . '</span> ' . $atts['normal_text'] . '</h2>
	            <div class="ui-subtitle-block">' . $atts['sub_title'] . '</div>
	            <div id="success"></div>
	            ' . do_shortcode( '[contact-form-7 id="' . $atts['contact_from_7'] . '" ]' ) . '
	          </section>
	        </div>
      </div>';
	}else{
		$html = '
		<div class="block-table block-table-md ' . $atts['class'] . '">
	        <div class="block-table__cell col-md-6">
	          <section data-stellar-background-ratio="0.4" class="section-form-contact section-form-contact_color_white  bg-primary stellar">
	            <div class="ui-decor-1"><img src="' . $icon_src[0] . '" alt="' . $atts['highlight_text'] . ' ' . $atts['sub_title'] . '"></div>
	            <h2 class="ui-title-block"><span>' . $atts['highlight_text'] . '</span> ' . $atts['normal_text'] . '</h2>
	            <div class="ui-subtitle-block">' . $atts['sub_title'] . '</div>
	            <div id="success"></div>
	            ' . do_shortcode( '[contact-form-7 id="' . $atts['contact_from_7'] . '" ]' ) . '
	          </section>
	        </div>
	        <div class="block-table__cell col-md-6"><img src="' . $imageleft_src[0] . '" alt="' . $atts['highlight_text'] . ' ' . $atts['sub_title'] . '"></div>
      </div>';
	}
	return $html;
}
