<?php
add_action( 'init', 'vc_dvents_client', 1000 );
function vc_dvents_client() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Clients", 'ova-dvents' ),
			"base"                    => "dvents_client",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"as_parent"               => array( 'only' => 'dvents_client_item' ),
			"content_element"         => true,
			"js_view"                 => 'VcColumnView',
			"show_settings_on_create" => false,
			"params"                  => array(
				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '7000'
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show dot", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => false,
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => false,
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );


		if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
			class WPBakeryShortCode_dvents_client extends WPBakeryShortCodesContainer {
			}
		}


	}
}


add_shortcode( 'dvents_client', 'dvents_client' );
function dvents_client( $atts, $content = null ) {

	$atts = shortcode_atts(
		array(
			'time_next'     => '7000',
			'show_dot'      => false,
			'stop_on_hover' => false,
			'class'         => '',
		), $atts );
	$atts['show_dot'] =  $atts['show_dot'] == true?'true':'false';
	$atts['stop_on_hover'] =  $atts['stop_on_hover'] == true?'true':'false';

	$html = '<div 
	data-min480="1" 
	data-min768="3" 
	data-min992="5" 
	data-min1200="5" 
	data-pagination="' . $atts['show_dot'] . '" 
	data-navigation="false" 
	data-auto-play="' . $atts['time_next'] . '" 
	data-stop-on-hover="' . $atts['stop_on_hover'] . '" 
	class="b-brands clientwp owl-carousel owl-theme enable-owl-carousel ' . $atts['class'] . '">' . do_shortcode( $content ) . '</div>';

	return $html;
}
