<?php
add_action( 'init', 'vc_dvents_client_item', 1000 );
function vc_dvents_client_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Client item", 'ova-dvents' ),
			"base"     => "dvents_client_item",
			"as_child" => array( 'only' => 'dvents_review' ),
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Logo", 'ova-dvents' ),
					"param_name" => "logo",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Name", 'ova-dvents' ),
					"param_name" => "name",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Link Image", 'ova-dvents' ),
					"param_name" => "link_img",
					"value"      => ""
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Target Link", 'ova-dvents' ),
					"param_name" => "target_link",
					"value"      => array(
						__( 'Blank', 'ova-dvents' ) => "_blank",
						__( 'Self', 'ova-dvents' )  => "_self",
					),
					"default"	=> '_blank'
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

		if ( class_exists( 'WPBakeryShortCode' ) ) {
			class WPBakeryShortCode_dvents_client_item extends WPBakeryShortCode {
			}
		}


	}
}


add_shortcode( 'dvents_client_item', 'dvents_client_item' );
function dvents_client_item( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'logo'  => '',
			'name'    => '',
			'link_img'	=> '',
			'target_link'	=> '_blank',
			'class'   => '',
		), $atts );

	$src = wp_get_attachment_image_src($atts['logo'], 'full' );
	$html = '<div class="b-brands__item '.$atts['class'].'">';
		$html .= $atts['link_img'] != '' ? '<a href="'.$atts['link_img'].'" target="'.$atts['target_link'].'" ><img src="'.$src[0].'" alt="'.$atts['name'].'" class="img-responsive center-block"/></a>' : '<img src="'.$src[0].'" alt="'.$atts['name'].'" class="img-responsive center-block"/>';
	$html .= '</div>';
	return $html;
}
