<?php
add_action( 'init', 'vc_dvents_box_radius', 1000 );
function vc_dvents_box_radius() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Box radius", 'ova-dvents' ),
			"base"     => "dvents_box_radius",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Background image", 'ova-dvents' ),
					"param_name" => "background_image",
					"value"      => ""
				),

				array(
					"type"       => "colorpicker",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Background color", 'ova-dvents' ),
					"param_name" => "background_color",
					"value"      => ""
				),


				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub Title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button text", 'ova-dvents' ),
					"param_name" => "button_text",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Button link", 'ova-dvents' ),
					"param_name" => "button_link",
					"value"      => ""
				),


				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_box_radius', 'dvents_box_radius' );
function dvents_box_radius( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'background_image' => '',
			'background_color' => '',
			'title'            => '',
			'sub_title'        => '',
			'button_text'      => '',
			'button_link'      => '',
			'class'            => '',
		), $atts );
	$backgroundimage = '';
	if ($atts['background_image'] != '') {
		$src         = wp_get_attachment_image_src( $atts['background_image'], 'full' );
		$backgroundimage = 'background-image: url(' . $src[0] . ');';
	}
	$button = $atts['button_text'] != ''?'<a href="'.$atts['button_link'].'" class="b-info__btn btn btn-default btn-sm btn-effect">'.$atts['button_text'].'</a>':'';
	$html = '
			<section data-stellar-background-ratio="0.4" class="b-info section-texture section-radius stellar section-texture_green section-radius '.$atts['class'].'" style=" background-color: '.$atts['background_color'].';'.$backgroundimage.'">
              <h2 class="b-info__title">'.$atts['title'].'</h2>
              <div class="b-info__text">'.$atts['sub_title'].'</div>
              '.$button.'
            </section>
	';

	return $html;
}
