<?php
add_action( 'init', 'vc_dvents_box_on_slideshow', 1000 );
function vc_dvents_box_on_slideshow() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "Box on slideshow", 'ova-dvents' ),
			"base"     => "dvents_box_on_slideshow",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(


				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Normal text", 'ova-dvents' ),
					"param_name" => "normal_text",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Bold text", 'ova-dvents' ),
					"param_name" => "bold_text",
					"value"      => ""
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Line in button", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' )  => "true",
						__( 'False', 'ova-dvents' ) => "false",
					),
					"default"    => "true"
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),

			)
		) );

	}
}


add_shortcode( 'dvents_box_on_slideshow', 'dvents_box_on_slideshow' );
function dvents_box_on_slideshow( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'normal_text' => '',
			'bold_text'   => '',
			'show_line'	=> 'true',
			'class'       => false,
		), $atts );

	$normal_text = ($atts['normal_text']!='')?'<div class="b-request-estimate__info">'.$atts['normal_text'].'</div>':'';

	$line = $atts['show_line'] == 'true' ? '<span class="ui-decor-2"></span>' : '';
	$bold_text = ($atts['bold_text']!='')?'<div class="b-request-estimate__title bg-primary">'.$line.' '.$atts['bold_text'].'</div>':'';


	$html = ' 
 		<div class="col-xs-12">
            <div class="section-area">
              <div class="b-request-estimate">
                '.$normal_text.$bold_text.'
              </div>
            </div>
          </div>';
	return $html;
}
