<?php
add_action( 'init', 'vc_dvents_blogs', 1000 );
function vc_dvents_blogs() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"                    => __( "Blogs", 'ova-dvents' ),
			"base"                    => "dvents_blogs",
			"class"                   => "",
			"category"                => __( "Dvents", 'ova-dvents' ),
			"icon"                    => "icon-qk",
			"show_settings_on_create" => true,
			"params"                  => array(

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Limit", 'ova-dvents' ),
					"param_name" => "limit",
					"value"      => '10'
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Time next (ms). Ex: 700", 'ova-dvents' ),
					"param_name" => "time_next",
					"value"      => '7000'
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Show dot", 'ova-dvents' ),
					"param_name" => "show_dot",
					"value"      => false,
				),

				array(
					"type"       => "checkbox",
					"holder"     => "div",
					"class"      => "",
					"heading"    => __( "Stop on hover", 'ova-dvents' ),
					"param_name" => "stop_on_hover",
					"value"      => false,
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show Date", 'ova-dvents' ),
					"param_name" => "show_date",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),
				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),
			)
		) );

	}
}


add_shortcode( 'dvents_blogs', 'dvents_blogs' );
function dvents_blogs( $atts, $content = null ) {

	$atts                  = shortcode_atts(
		array(
			'time_next'     => '7000',
			'show_dot'      => false,
			'stop_on_hover' => false,
			'limit'         => '10',
			'show_line'		=> 'true',
			'show_date'		=> 'true',
			'class'         => '',
		), $atts );
	$atts['show_dot']      = $atts['show_dot'] == true ? 'true' : 'false';
	$atts['stop_on_hover'] = $atts['stop_on_hover'] == true ? 'true' : 'false';
	$html                  = '
	<div 
		style = "padding-bottom:60px"
		data-min480="1" 
		data-min768="2" 
		data-min992="3" 
		data-min1200="3" 
		data-pagination="' . $atts['show_dot'] . '" 
		data-navigation="false" 
		data-auto-play="' . $atts['time_next'] . '" 
		data-stop-on-hover="' . $atts['stop_on_hover'] . '" 
		class="owl-carousel owl-theme enable-owl-carousel ' . $atts['class'] . '">';

	$args = array(
		'post_type'      => 'post',
		'post_status'    => array( 'publish' ),
		'posts_per_page' => $atts['limit']
	);

	$query = new WP_Query( $args );

	while ( $query->have_posts() ) {
		$query->the_post();
		$src  = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'size_380x290' );
		$html .= '<section class="b-post-sm b-post-sm-2 ova_blog clearfix">
                  <div class="entry-media">
                  	<a href="' . $src[0] . '" class="js-zoom-images"><img src="' . $src[0] . '" alt="' . get_the_title() . '" class="img-responsive img-responsive-blog"/></a>
                  </div>
                  <div class="entry-main">
                    <div class="entry-header">';

                      
                     	$html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 ui-decor-2_vert bg-primary"></div>' : '<div style="margin-bottom:38px;"></div>';
                  	  

                      $html .= '<h2 class="entry-title entry-title_spacing ui-title-inner"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h2>';
                    $html .= '</div>';

                    $html .= $atts['show_date'] == 'true' ? '<div class="entry-footer">
		                      <div class="entry-meta">
		                      	<span class="entry-meta__item">
		                      	<i class="icon icon-calendar"></i>' . __( 'Posted', 'ova-dvents' ) . '<a href="' . get_the_permalink() . '" class="entry-meta__link"> ' . get_the_date() . '</a>
		                      	</span>
		                      </div>
		                    </div>' : '';

                  $html .= '</div>
                </section>';
	}

	$html .= '</div>';
	wp_reset_query();

	

	return $html;
}
