<?php
add_action( 'init', 'vc_dvents_about_item', 1000 );
function vc_dvents_about_item() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"     => __( "About item", 'ova-dvents' ),
			"base"     => "dvents_about_item",
			"class"    => "",
			"category" => __( "Dvents", 'ova-dvents' ),
			"icon"     => "icon-qk",
			"params"   => array(

				array(
					"type"       => "attach_image",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Image", 'ova-dvents' ),
					"param_name" => "image",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Title", 'ova-dvents' ),
					"param_name" => "title",
					"value"      => ""
				),

				array(
					"type"       => "textfield",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Link", 'ova-dvents' ),
					"param_name" => "link",
					"value"      => ""
				),

				array(
					"type"       => "textarea",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Sub title", 'ova-dvents' ),
					"param_name" => "sub_title",
					"value"      => ""
				),
				array(
					"type"       => "dropdown",
					"holder"     => "div",
					"class"      => "",
					"heading"    => esc_html__( "Show line", 'ova-dvents' ),
					"param_name" => "show_line",
					"value"      => array(
						__( 'True', 'ova-dvents' ) => "true",
						__( 'False', 'ova-dvents' )  => "false",
					),
					'default'	=> 'true'
				),

				array(
					"type"        => "textfield",
					"holder"      => "div",
					"class"       => "",
					"heading"     => __( "Class", 'ova-dvents' ),
					"param_name"  => "class",
					"default"     => '',
					"description" => esc_html__( "Insert class to use for your style", 'ova-dvents' )
				),


			)
		) );

	}
}

add_shortcode( 'dvents_about_item', 'dvents_about_item' );
function dvents_about_item( $atts, $content = null ) {
	$atts = shortcode_atts(
		array(
			'image'     => '',
			'title'     => '',
			'link'     => '',
			'sub_title' => '',
			'show_line'	=> 'true',
			'class'     => '',
		), $atts );
	$image = '';
	if ($atts['image']!=''){
		$src = wp_get_attachment_image_src($atts['image'],'full');
		$image = '<a href="'.$src[0].'" class="js-zoom-images"><img src="'.$src[0].'" alt="'.$atts['title'].'" class="img-responsive"/></a>';
	}
	$html = '
		  <section class="b-post-sm b-post-sm-1 b-post-sm-1_align_center clearfix '.$atts['class'].'">
                <div class="entry-media">'.$image.'</div>
                <div class="entry-main">
                  <div class="entry-header">';

                    $html .= $atts['show_line'] == 'true' ? '<div class="ui-decor-2 ui-decor-2_vert bg-primary"></div>' : '<div style="height: 38px;"></div>';
                    
                    $html .= '<h2 class="entry-title entry-title_spacing ui-title-inner"><a href="'.$atts['link'].'">'.$atts['title'].'</a></h2>';

                  $html .= '</div>
                  <div class="entry-content">
                    <p>'.$atts['sub_title'].'</p>
                  </div>
                </div>
              </section>
	';

	return $html;
}
