<?php

// Slideshow //////////////////////////////////////////////////////////////////////////////////
add_action( 'init', 'slideshow_init',0 );
function slideshow_init() {
    
    $labels = array(
        'name'               => esc_html__( 'Gallery', 'ova-dvents' ),
        'singular_name'      => esc_html__( 'Gallery', 'ova-dvents' ),
        'menu_name'          => esc_html__( 'Gallery', 'ova-dvents' ),
        'name_admin_bar'     => esc_html__( 'Gallery', 'ova-dvents' ),
        'add_new'            => esc_html__( 'Add New', 'ova-dvents' ),
        'add_new_item'       => esc_html__( 'Add New', 'ova-dvents' ),
        'new_item'           => esc_html__( 'New gallery', 'ova-dvents' ),
        'edit_item'          => esc_html__( 'Edit gallery', 'ova-dvents' ),
        'view_item'          => esc_html__( 'View gallery', 'ova-dvents' ),
        'all_items'          => esc_html__( 'All gallery', 'ova-dvents' ),
        'search_items'       => esc_html__( 'Search gallery', 'ova-dvents' ),
        'parent_item_colon'  => esc_html__( 'Parent gallery:', 'ova-dvents' ),
        'not_found'          => esc_html__( 'No gallery found.', 'ova-dvents' ),
        'not_found_in_trash' => esc_html__( 'No gallery found in Trash.', 'ova-dvents' ),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'menu_icon'          => 'dashicons-format-gallery',
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'gallery' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'supports'           => array( 'title', 'editor', 'author', 'thumbnail','comments', 'excerpt'),
        'taxonomies'          => array('gallerygroup'),
    );

    register_post_type( 'gallery', $args ); // Create post type: slideshow
}


add_action( 'init', 'create_slidegroup_taxonomies', 0 );
// create slidegroup taxonomy
function create_slidegroup_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => esc_html__( 'Groups', 'ova-dvents'),
        'singular_name'     => esc_html__( 'Groups', 'ova-dvents'),
        'search_items'      => esc_html__( 'Search Groups', 'ova-dvents'),
        'all_items'         => esc_html__( 'All Groups', 'ova-dvents' ),
        'parent_item'       => esc_html__( 'Parent Group', 'ova-dvents' ),
        'parent_item_colon' => esc_html__( 'Parent Group:' , 'ova-dvents'),
        'edit_item'         => esc_html__( 'Edit Group' , 'ova-dvents'),
        'update_item'       => esc_html__( 'Update Group' , 'ova-dvents'),
        'add_new_item'      => esc_html__( 'Add New Group' , 'ova-dvents'),
        'new_item_name'     => esc_html__( 'New Group Name' , 'ova-dvents'),
        'menu_name'         => esc_html__( 'Groups' , 'ova-dvents'),
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'gallery-groups' )
    );

    register_taxonomy( 'gallerygroup', array('gallery'), $args ); // Create taxonomy: slidegroup
}

// /Slideshow //////////////////////////////////////////////////////////////////////////////////



// Events //////////////////////////////////////////////////////////////////////////////////
add_action( 'init', 'event_init',0 );
function event_init() {

	$labels = array(
		'name'               => esc_html__( 'Events', 'ova-dvents' ),
		'singular_name'      => esc_html__( 'Events', 'ova-dvents' ),
		'menu_name'          => esc_html__( 'Events', 'ova-dvents' ),
		'name_admin_bar'     => esc_html__( 'Events', 'ova-dvents' ),
		'add_new'            => esc_html__( 'Add New', 'ova-dvents' ),
		'add_new_item'       => esc_html__( 'Add New', 'ova-dvents' ),
		'new_item'           => esc_html__( 'New event', 'ova-dvents' ),
		'edit_item'          => esc_html__( 'Edit event', 'ova-dvents' ),
		'view_item'          => esc_html__( 'View event', 'ova-dvents' ),
		'all_items'          => esc_html__( 'All event', 'ova-dvents' ),
		'search_items'       => esc_html__( 'Search event', 'ova-dvents' ),
		'parent_item_colon'  => esc_html__( 'Parent event:', 'ova-dvents' ),
		'not_found'          => esc_html__( 'No event found.', 'ova-dvents' ),
		'not_found_in_trash' => esc_html__( 'No event found in Trash.', 'ova-dvents' ),
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          => 'dashicons-calendar-alt',
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'event' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail','comments', 'excerpt'),
		'taxonomies'          => array('eventgroup'),
	);

	register_post_type( 'event', $args ); // Create post type: slideshow
}


add_action( 'init', 'create_slidegroup_taxonomies', 0 );
// create slidegroup taxonomy
function create_event_taxonomies() {
	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => esc_html__( 'Groups', 'ova-dvents'),
		'singular_name'     => esc_html__( 'Groups', 'ova-dvents'),
		'search_items'      => esc_html__( 'Search Groups', 'ova-dvents'),
		'all_items'         => esc_html__( 'All Groups', 'ova-dvents' ),
		'parent_item'       => esc_html__( 'Parent Group', 'ova-dvents' ),
		'parent_item_colon' => esc_html__( 'Parent Group:' , 'ova-dvents'),
		'edit_item'         => esc_html__( 'Edit Group' , 'ova-dvents'),
		'update_item'       => esc_html__( 'Update Group' , 'ova-dvents'),
		'add_new_item'      => esc_html__( 'Add New Group' , 'ova-dvents'),
		'new_item_name'     => esc_html__( 'New Group Name' , 'ova-dvents'),
		'menu_name'         => esc_html__( 'Groups' , 'ova-dvents'),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'event-groups' )
	);

	register_taxonomy( 'eventgroup', array('event'), $args ); // Create taxonomy: slidegroup
}

// /Event //////////////////////////////////////////////////////////////////////////////////




// Team //////////////////////////////////////////////////////////////////////////////////
add_action( 'init', 'team_init',0 );
function team_init() {

	$labels = array(
		'name'               => esc_html__( 'Teams', 'ova-dvents' ),
		'singular_name'      => esc_html__( 'Teams', 'ova-dvents' ),
		'menu_name'          => esc_html__( 'Teams', 'ova-dvents' ),
		'name_admin_bar'     => esc_html__( 'Teams', 'ova-dvents' ),
		'add_new'            => esc_html__( 'Add New', 'ova-dvents' ),
		'add_new_item'       => esc_html__( 'Add New', 'ova-dvents' ),
		'new_item'           => esc_html__( 'New Team', 'ova-dvents' ),
		'edit_item'          => esc_html__( 'Edit Team', 'ova-dvents' ),
		'view_item'          => esc_html__( 'View Team', 'ova-dvents' ),
		'all_items'          => esc_html__( 'All Team', 'ova-dvents' ),
		'search_items'       => esc_html__( 'Search Team', 'ova-dvents' ),
		'parent_item_colon'  => esc_html__( 'Parent Team:', 'ova-dvents' ),
		'not_found'          => esc_html__( 'No Team found.', 'ova-dvents' ),
		'not_found_in_trash' => esc_html__( 'No Team found in Trash.', 'ova-dvents' ),
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          => 'dashicons-groups',
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'team' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail','comments', 'excerpt'),
		'taxonomies'          => array('teamgroup'),
	);

	register_post_type( 'team', $args ); // Create post type: slideshow
}


add_action( 'init', 'create_team_taxonomies', 0 );
// create slidegroup taxonomy
function create_team_taxonomies() {
	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => esc_html__( 'Team Groups', 'ova-dvents'),
		'singular_name'     => esc_html__( 'Team Groups', 'ova-dvents'),
		'search_items'      => esc_html__( 'Search Team Groups', 'ova-dvents'),
		'all_items'         => esc_html__( 'All Team Groups', 'ova-dvents' ),
		'parent_item'       => esc_html__( 'Parent Team Group', 'ova-dvents' ),
		'parent_item_colon' => esc_html__( 'Parent Team Group:' , 'ova-dvents'),
		'edit_item'         => esc_html__( 'Edit Team Group' , 'ova-dvents'),
		'update_item'       => esc_html__( 'Update Team Group' , 'ova-dvents'),
		'add_new_item'      => esc_html__( 'Add New Team Group' , 'ova-dvents'),
		'new_item_name'     => esc_html__( 'New Group Name' , 'ova-dvents'),
		'menu_name'         => esc_html__( 'Groups' , 'ova-dvents'),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'event-groups' )
	);

	register_taxonomy( 'teamgroup', array('team'), $args ); // Create taxonomy: slidegroup
}

// /Slideshow //////////////////////////////////////////////////////////////////////////////////


