<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */


add_action( 'cmb2_init', 'dvents_metaboxes_default' );
function dvents_metaboxes_default() {

	// Start with an underscore to hide fields from custom fields list
	$prefix = 'dvents_met_';


	/* Page Settings ***************************************************************************/
	/* ************************************************************************************/
	$page_settings = new_cmb2_box( array(
		'id'           => 'page_heading_settings',
		'title'        => esc_html__( 'Show Page Heading', 'ova-dvents' ),
		'object_types' => array( 'page' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true,

	) );

	// Display title of page
	$page_settings->add_field( array(
		'name'             => esc_html__( 'Show title of page', 'ova-dvents' ),
		'desc'             => esc_html__( 'Allow display title of page', 'ova-dvents' ),
		'id'               => $prefix . 'page_heading',
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => array(
			'yes' => esc_html__( 'Yes', 'ova-dvents' ),
			'no'  => esc_html__( 'No', 'ova-dvents' )
		),
		'default'          => 'yes',

	) );


	/* Post Settings *********************************************************************************/
	/* *******************************************************************************/
	$post_settings = new_cmb2_box( array(
		'id'           => 'post_video',
		'title'        => esc_html__( 'Post Settings', 'ova-dvents' ),
		'object_types' => array( 'post' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	// Video or Audio
	$post_settings->add_field( array(
		'name' => esc_html__( 'Link audio or video', 'ova-dvents' ),
		'desc' => esc_html__( 'Insert link audio or video use for video/audio post-format', 'ova-dvents' ),
		'id'   => $prefix . 'embed_media',
		'type' => 'oembed',
	) );


	// Gallery image
	$post_settings->add_field( array(
		'name' => esc_html__( 'Gallery image', 'ova-dvents' ),
		'desc' => esc_html__( 'image in gallery post format', 'ova-dvents' ),
		'id'   => $prefix . 'file_list',
		'type' => 'file_list',
	) );

	// Post feature
	$post_settings->add_field( array(
		'name'    => esc_html__( 'Featured', 'ova-dvents' ),
		'desc'    => esc_html__( 'Post featured', 'ova-dvents' ),
		'id'      => $prefix . 'post_featured',
		'type'    => 'select',
		'options' => array(
			'1' => esc_html__( 'Yes', 'ova-dvents' ),
			'0' => esc_html__( 'No', 'ova-dvents' )
		),
		'default' => '0',
	) );


	/* Gallery Settings *********************************************************************************/
	/* *******************************************************************************/
	$post_settings = new_cmb2_box( array(
		'id'           => 'gallery_attribute',
		'title'        => esc_html__( 'Gallery attribute', 'ova-dvents' ),
		'object_types' => array( 'gallery' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Order', 'ova-dvents' ),
		'desc'    => esc_html__( 'Order in gallery', 'ova-dvents' ),
		'id'      => $prefix . 'gallery_order',
		'type'    => 'text_small',
		'default' => 0
	) );


	/* Events Settings *********************************************************************************/
	/* *******************************************************************************/
	$post_settings = new_cmb2_box( array(
		'id'           => 'event_attribute',
		'title'        => esc_html__( 'Event attribute', 'ova-dvents' ),
		'object_types' => array( 'event' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Featured Image v2', 'ova-dvents' ),
		'id'      => $prefix . 'featured_image',
		'type'    => 'file',
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Start time', 'ova-dvents' ),
		'id'      => $prefix . 'event_start_time',
		'type'    => 'text_datetime_timestamp',
		'default' => 0
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'End time', 'ova-dvents' ),
		'id'      => $prefix . 'event_end_time',
		'type'    => 'text_datetime_timestamp',
		'default' => 0
	) );
	$post_settings->add_field( array(
		'name'    => esc_html__( 'Address', 'ova-dvents' ),
		'id'      => $prefix . 'event_address',
		'type'    => 'text',
		'default' => ''
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Order', 'ova-dvents' ),
		'desc'    => esc_html__( 'Order in event', 'ova-dvents' ),
		'id'      => $prefix . 'event_order',
		'type'    => 'text_small',
		'default' => 0
	) );


	/* Team Settings *********************************************************************************/
	/* *******************************************************************************/
	$post_settings = new_cmb2_box( array(
		'id'           => 'team_attribute',
		'title'        => esc_html__( 'Team attribute', 'ova-dvents' ),
		'object_types' => array( 'team' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Facebook', 'ova-dvents' ),
		'id'      => $prefix . 'team_facebook',
		'type'    => 'text',
		'default' => ''
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Twitter', 'ova-dvents' ),
		'id'      => $prefix . 'team_twitter',
		'type'    => 'text',
		'default' => ''
	) );
	$post_settings->add_field( array(
		'name'    => esc_html__( 'Google plus', 'ova-dvents' ),
		'id'      => $prefix . 'team_google_plus',
		'type'    => 'text',
		'default' => ''
	) );

	$post_settings->add_field( array(
		'name'    => esc_html__( 'Instagram', 'ova-dvents' ),
		'id'      => $prefix . 'team_instagram',
		'type'    => 'text',
		'default' => ''
	) );


	$post_settings->add_field( array(
		'name'    => esc_html__( 'Order', 'ova-dvents' ),
		'id'      => $prefix . 'team_order',
		'type'    => 'text_small',
		'default' => '0'
	) );


	/* Header Settings ***************************************************************/
	/* ********************************************************************************/
	$header_settings = new_cmb2_box( array(
		'id'           => 'header_settings',
		'title'        => esc_html__( 'Header Settings', 'ova-dvents' ),
		'object_types' => array( 'page', 'post' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	$header_settings->add_field( array(
		'name' => esc_html__( 'Background Header', 'ova-dvents' ),
		'id'   => $prefix . 'bg_header',
		'type' => 'file',
	) );

	$header_settings->add_field( array(
		'name' => esc_html__( 'Header title', 'ova-dvents' ),
		'id'   => $prefix . 'header_title',
		'type' => 'text',
	) );

	$header_settings->add_field( array(
		'name'             => esc_html__( 'Show breadcrumbs', 'ova-dvents' ),
		'id'               => $prefix . 'show_breadcrumbs',
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => array(
			'true'  => esc_html__( 'Show', 'ova-dvents' ),
			'false' => esc_html__( 'Hide', 'ova-dvents' ),
		),
		'default'          => 'true',

	) );


	/* General Settings ***************************************************************/
	/* ********************************************************************************/
	$general_settings = new_cmb2_box( array(
		'id'           => 'layout_settings',
		'title'        => esc_html__( 'General Settings', 'ova-dvents' ),
		'object_types' => array( 'page', 'post','event' ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
	) );

	$general_settings->add_field( array(
		'name'             => esc_html__( 'Header Version', 'ova-dvents' ),
		'id'               => $prefix . 'header_version',
		'description'      => esc_html__( 'This value will override value in customizer', 'ova-dvents' ),
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => dvents_load_header_metabox(),
		'default'          => 'global'

	) );

	$general_settings->add_field( array(
		'name'             => esc_html__( 'Footer Version', 'ova-dvents' ),
		'id'               => $prefix . 'footer_version',
		'description'      => esc_html__( 'This value will override value in customizer', 'ova-dvents' ),
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => dvents_load_footer_metabox(),
		'default'          => 'global'

	) );

	$general_settings->add_field( array(
		'name'             => esc_html__( 'Main Layout', 'ova-dvents' ),
		'desc'             => esc_html__( 'This value will override value in theme customizer', 'ova-dvents' ),
		'id'               => $prefix . 'main_layout',
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => array(
			'global'        => esc_html__( 'Global in customizer', 'ova-dvents' ),
			'right_sidebar' => esc_html__( 'Right Sidebar', 'ova-dvents' ),
			'left_sidebar'  => esc_html__( 'Left Sidebar', 'ova-dvents' ),
			'no_sidebar'    => esc_html__( 'No Sidebar', 'ova-dvents' )
		),
		'default'          => 'global',

	) );


	$general_settings->add_field( array(
		'name'             => esc_html__( 'Width of site', 'ova-dvents' ),
		'desc'             => esc_html__( 'This value will override value in theme customizer', 'ova-dvents' ),
		'id'               => $prefix . 'width_site',
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => array(
			'global' => esc_html__( 'Global in customizer', 'ova-dvents' ),
			'wide'   => esc_html__( 'Wide', 'ova-dvents' ),
			'boxed'  => esc_html__( 'Boxed', 'ova-dvents' ),
		),
		'default'          => 'global',

	) );


}

