<?php


function dvents_customize_register( $wp_customize ) {

	/* Remove Colors &  Header Image Customize */
	$wp_customize->remove_section('colors');
	$wp_customize->remove_section('header_image');


	// Typography setting ////////////////////////////////////////////////////////////////////////////////////////////////////////
	$wp_customize->add_section( 'typography_section' , array(
	    'title'      => esc_html__( 'Typography setting', 'ova-dvents' ),
	    'priority'   => 29,
	) );


	$wp_customize->add_setting( 'body_font', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'Roboto',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control( 
		new Google_Font_Dropdown_Custom_Control( 
		$wp_customize, 
		'body_font', 
		array(
			'label'          => esc_html__('Body font','ova-dvents'),
            'section'        => 'typography_section',
            'settings'       => 'body_font',
		) ) 
	);



	$wp_customize->add_setting( 'heading_font', array(
		'type' => 'theme_mod', // or 'option'
		'capability' => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
		'default' => 'Raleway',
		'transport' => 'refresh', // or postMessage
		'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name

	) );

	$wp_customize->add_control(
		new Google_Font_Dropdown_Custom_Control(
			$wp_customize,
			'heading_font',
			array(
				'label'          => esc_html__('Heading font','ova-dvents'),
				'section'        => 'typography_section',
				'settings'       => 'heading_font',
			) )
	);



	$wp_customize->add_setting( 'button_font', array(
		'type' => 'theme_mod', // or 'option'
		'capability' => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
		'default' => 'Poppins',
		'transport' => 'refresh', // or postMessage
		'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name

	) );

	$wp_customize->add_control(
		new Google_Font_Dropdown_Custom_Control(
			$wp_customize,
			'button_font',
			array(
				'label'          => esc_html__('Button font','ova-dvents'),
				'section'        => 'typography_section',
				'settings'       => 'button_font',
			) )
	);


	$wp_customize->add_setting( 'main_color', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => '#dd3333',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 
		'main_color', 
		array(
			'label'          => esc_html__("Main color",'ova-dvents'),
            'section'        => 'typography_section',
            'settings'       => 'main_color',
		) ) 
	);

	$wp_customize->add_setting( 'show_line', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'yes',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('show_line', array(
		'label' => esc_html('Show line','ova-dvents'),
		'description' => esc_html('Display line in theme. Note this isn\'t effect to element of Visual Composer ' ,'ova-dvents'),
		'section' => 'typography_section',
		'settings' => 'show_line',
		'type' =>'select',
		'choices' => array(
			'yes' => 'yes',
			'no' => 'no'
		)

	));


	$wp_customize->add_setting( 'dvents_custom_font', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => '',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('dvents_custom_font', array(
		'label' => esc_html__('Custom Font','ova-dvents'),
		'description' => esc_html__('Step 1: Insert font-face in style.css file: Refer https://css-tricks.com/snippets/css/using-font-face/.  Step 2: Insert name-font here. For example: name-font1, name-font2. Step 3: Refresh customize page to display new font in dropdown font field.','ova-dvents'),
		'section' => 'typography_section',
		'settings' => 'dvents_custom_font',
		'type' =>'textarea'
	));	

	
	// /Typography setting ////////////////////////////////////////////////////////////////////////////////////////////////////////


	// Header setting ////////////////////////////////////////////////////////////////////////////////////////////////////////
	$wp_customize->add_section( 'header_section' , array(
	    'title'      => esc_html( 'Header Global', 'ova-dvents' ),
	    'priority'   => 30,
	) );

	$wp_customize->add_setting( 'header_version', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'default',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('header_version', array(
		'label' => esc_html('Header version','ova-dvents'),
		'description' => esc_html('Select Global Header. You can override Header in config of Post/Page','ova-dvents'),
		'section' => 'header_section',
		'settings' => 'header_version',
		'type' =>'select',
		'choices' => dvents_load_header()

	));

	$wp_customize->add_setting( 'logo_dark', array(
		'type' => 'theme_mod', // or 'option'
		'capability' => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
		'default' => '',
		'transport' => 'refresh', // or postMessage
		'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name

	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo_dark', array(
		'label'    => esc_html__( 'Logo', 'ova-dvents' ),
		'section'  => 'header_section',
		'settings' => 'logo_dark'
	)));

	$wp_customize->add_setting( 'logo', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => '',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo', array(
	    'label'    => esc_html__( 'Logo White', 'ova-dvents' ),
	    'section'  => 'header_section',
	    'settings' => 'logo'
	)));


	

	
	// /Header setting ////////////////////////////////////////////////////////////////////////////////////////////////////////



	// Footer setting ////////////////////////////////////////////////////////////////////////////////////////////////////////

	$wp_customize->add_section( 'footer_section' , array(
	    'title'      => esc_html( 'Footer Global', 'ova-dvents' ),
	    'priority'   => 30,
	) );

	$wp_customize->add_setting( 'footer_version', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'default',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('footer_version', array(
		'label' => esc_html('Footer version','ova-dvents'),
		'description' => esc_html('Select Global Footer. You can override Footer in config of Post/Page','ova-dvents'),
		'section' => 'footer_section',
		'settings' => 'footer_version',
		'type' =>'select',
		'choices' => dvents_load_footer()

	));
	
	// /Footer setting ////////////////////////////////////////////////////////////////////////////////////////////////////////



	// Layout setting ////////////////////////////////////////////////////////////////////////////////////////////////////////

	$wp_customize->add_section( 'layout_section' , array(
	    'title'      => esc_html( 'Layout Global', 'ova-dvents' ),
	    'priority'   => 30,
	) );

	$wp_customize->add_setting( 'main_layout', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'right_sidebar',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('main_layout', array(
		'label' => esc_html__('Global Layout for site','ova-dvents'),
		'section' => 'layout_section',
		'settings' => 'main_layout',
		'description' => esc_html__('You can override Layout in config of Post/Page', 'ova-dvents'),
		'type' =>'select',
		'choices' => array(
			'right_sidebar' => esc_html__('Right Sidebar', 'ova-dvents'),
			'left_sidebar' => esc_html__('Left Sidebar', 'ova-dvents'),
			'no_sidebar' => esc_html__('No Sidebar','ova-dvents')
			)

	));


	$wp_customize->add_setting( 'width_site', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => 'wide',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('width_site', array(
		'label' => esc_html__('Width of site','ova-dvents'),
		'section' => 'layout_section',
		'settings' => 'width_site',
		'type' =>'select',
		'choices' => array(
			'wide' => esc_html__( 'Wide', 'ova-dvents' ),
            'boxed'   => esc_html__('Boxed', 'ova-dvents')
			)

	));

	// Sidebar column setting
	$wp_customize->add_setting( 'sidebar_column', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => '4',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('sidebar_column', array(
		'label' => esc_html__('Sidebar column','ova-dvents'),
		'description' => esc_html__('main column + sidebar column = 12 columns','ova-dvents'),
		'section' => 'layout_section',
		'settings' => 'sidebar_column',
		'type' =>'select',
		'choices' => array(
			'1' => esc_html__('1 column', 'ova-dvents'),
			'2' => esc_html__('2 columns', 'ova-dvents'),
			'3' => esc_html__('3 columns', 'ova-dvents'),
			'4' => esc_html__('4 columns', 'ova-dvents'),
			'5' => esc_html__('5 columns', 'ova-dvents'),
			'6' => esc_html__('6 columns', 'ova-dvents')
			)
	));

	// Main column settings
	$wp_customize->add_setting( 'main_column', array(
	  'type' => 'theme_mod', // or 'option'
	  'capability' => 'edit_theme_options',
	  'theme_supports' => '', // Rarely needed.
	  'default' => '8',
	  'transport' => 'refresh', // or postMessage
	  'sanitize_callback' => 'dvents_fun_sanitize_callback' // Get function name 
	  
	) );

	$wp_customize->add_control('main_column', array(
		'label' => esc_html__('Main column','ova-dvents'),
		'description' => esc_html__('main column + sidebar column = 12 columns','ova-dvents'),
		'section' => 'layout_section',
		'settings' => 'main_column',
		'type' =>'select',
		'choices' => array(
			'11' => esc_html__('11 columns', 'ova-dvents'),
			'10' => esc_html__('10 columns', 'ova-dvents'),
			'9' => esc_html__('9 columns', 'ova-dvents'),
			'8' => esc_html__('8 columns', 'ova-dvents'),
			'7' => esc_html__('7 columns', 'ova-dvents'),
			'6' => esc_html__('6 columns', 'ova-dvents'),
			)
	));
	
	// /Layout setting ////////////////////////////////////////////////////////////////////////////////////////////////////////

	



}

function dvents_fun_sanitize_callback($value){
    return $value;
}


add_action( 'customize_register', 'dvents_customize_register' );	

