<?php
add_action('wp_enqueue_scripts', 'dvents_theme_scripts_styles');
add_action('wp_enqueue_scripts', 'dvents_primary_color');




function dvents_theme_scripts_styles() {


    /* Google Font */
    wp_enqueue_style( 'ova-dvents-fonts', dvents_customize_google_fonts(), array(), null );

    // enqueue the javascript that performs in-link comment reply fanciness
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' ); 
    }



    
    /* Add Javascript  */
    wp_enqueue_script('jquery_migrate', DVENTS_URI.'/assets/libs/jquery-migrate-1.2.1.js', array('jquery'),null,true);
    wp_enqueue_script('bootstrap', DVENTS_URI.'/assets/libs/bootstrap/bootstrap.js', array('jquery'),null,true);
    
    wp_enqueue_script('bootstrap-select', DVENTS_URI.'/assets/plugins/bootstrap-select/js/bootstrap-select.min.js', array('jquery'),null,true);
    wp_enqueue_script('owl.carousel.min', DVENTS_URI.'/assets/plugins/owl-carousel/owl.carousel.min.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.easing', DVENTS_URI.'/assets/plugins/bxslider/vendor/jquery.easing.1.3.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.fitvids', DVENTS_URI.'/assets/plugins/bxslider/vendor/jquery.fitvids.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.bxslider.min', DVENTS_URI.'/assets/plugins/bxslider/jquery.bxslider.min.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.magnific-popup.min', DVENTS_URI.'/assets/plugins/magnific-popup/jquery.magnific-popup.min.js', array('jquery'),null,true);
    wp_enqueue_script('slidebar', DVENTS_URI.'/assets/plugins/headers/slidebar.js', array('jquery'),null,true);
    wp_enqueue_script('header', DVENTS_URI.'/assets/plugins/headers/header.js', array('jquery'),null,true);
    wp_enqueue_script('jqBootstrapValidation', DVENTS_URI.'/assets/plugins/jqBootstrapValidation.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.stellar.min', DVENTS_URI.'/assets/plugins/stellar/jquery.stellar.min.js', array('jquery'),null,true);
    wp_enqueue_script('isotope.pkgd.min', DVENTS_URI.'/assets/plugins/isotope/isotope.pkgd.min.js', array('jquery'),null,true);
    wp_enqueue_script('imagesLoaded', DVENTS_URI.'/assets/plugins/isotope/imagesLoaded.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.easypiechart.min', DVENTS_URI.'/assets/plugins/rendro-easy-pie-chart/jquery.easypiechart.min.js', array('jquery'),null,true);
    wp_enqueue_script('waypoints.min', DVENTS_URI.'/assets/plugins/rendro-easy-pie-chart/waypoints.min.js', array('jquery'),null,true);
    wp_enqueue_script('scrollreveal.min', DVENTS_URI.'/assets/plugins/scrollreveal/scrollreveal.min.js', array('jquery'),null,true);
    wp_enqueue_script('jquery.sliderPro.min', DVENTS_URI.'/assets/plugins/slider-pro/jquery.sliderPro.min.js', array('jquery'),null,true);
	wp_enqueue_script('ova-dvents-custom', DVENTS_URI.'/assets/js/custom.js', array('jquery'),null,true);



    /* Add Css  */
    wp_enqueue_style('bootstrap', DVENTS_URI.'/assets/libs/bootstrap/bootstrap.css', array(), null);
    wp_enqueue_style('font-awesome', DVENTS_URI.'/assets/plugins/font-awesome-4.4.0/css/font-awesome.min.css', array(), null);
    wp_enqueue_style('ova-dvents-master', DVENTS_URI.'/assets/css/master.css', array(), null);

    wp_enqueue_style('ova-dvents-default', DVENTS_URI.'/assets/css/default.css', array(), null);

    if ( is_child_theme() ) {
      wp_enqueue_style( 'parent-stylesheet', trailingslashit( get_template_directory_uri() ) . 'style.css', array(), null );
    }

    wp_enqueue_style( 'ova-dvents-style', get_stylesheet_uri(), array(), null );

}



function dvents_primary_color(){

  $main_color = get_theme_mod('main_color', '#ed4a43');
  $body_font = str_replace('ovatheme_','',get_theme_mod('body_font', 'Roboto'));
  $button_font = str_replace('ovatheme_','',get_theme_mod('button_font', 'Poppins'));
  $heading_font = str_replace('ovatheme_','',get_theme_mod('heading_font', 'Poppins'));

  $show_line = get_theme_mod( 'show_line', 'yes' );
  $hide_line = '';
  if( $show_line == 'no' ){
  	$hide_line = "
  		.footer .ui-decor-2,
  		.b-title-page .ui-decor-2,
  		.btn .icon{
  			display: none;
  		}
  		.b-events-2 .ui-decor-2,
  		.widget-searce .ui-decor-2,
  		.widget-title .ui-decor-2,
  		.ui-subtitle-block .ui-decor-2,
  		.b-blockquote-1:before,
  		.section-form-contact .ui-title-block .ui-decor-2{
  			display: none;
  		}
  	";
  }

  $custom_css = "
    body{
      font-family: {$body_font}, sans-serif !important;
    }
    
    h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6{
        font-family: {$heading_font};
    }
    .btn, 
    .b-isotope-filter > li > a
    {
        font-family: {$button_font};
    }
    
	a,
	.text-primary,
	.text-primary_h:hover,
	.text-primary_b:before,
	.text-primary_a:after,
	.list > li > a:hover,
	.list-mark-1 li:before,
	.pager li > a:hover,
	.pager li > a:hover .icon,
	.pagination_primary > li:first-child > a:hover,
	.pagination_primary > li:first-child > a:hover .icon,
	.pagination_primary > li:last-child > a:hover,
	.pagination_primary > li:last-child > a:hover .icon,
	.search-close:hover,
	.breadcrumb > li > a:hover,
	.navbar .navbar-nav > li > a:hover,
	.b-blockquote-3:after,
	.b-contact-social-net .social-net .social-net__link:hover,
	.pagination > .active > a,
	.pagination > .active > span,
	.pagination > .active > a:hover,
	.pagination > .active > span:hover,
	.pagination > .active > a:focus,
	.pagination > .active > span:focus,
	.footer-list__link:hover,
	.list_icon_color-primary li:before {color: $main_color;}
	.dropdown-menu > .active > a{
		background-color: $main_color !important;
	}

	.b-post-sm-2 .entry-title a:hover,
	.b-events-2 .b-events-calendar__wrap:hover,
	.b-post-sm-2 .entry-title:hover,
	.b-post-sm-2 .entry-title a:hover,
	.b-events__title a:hover,
	.b-events-2__title a:hover,
	.pagination .current,
	.pagination li a:hover,
	.pagination li span:hover,
	ul.yamm>li.active>a,
	.b-events__details .icon
	{
		color: $main_color !important;
	}
	.bg-primary,
	.bg-primary_h:hover,
	.bg-primary_b:before,
	.bg-primary_a:after,
	.btn:after,
	.pagination_primary > .active > a,
	.pagination_primary > .active > span,
	.pagination_primary > .active > a,
	.pagination_primary > .active > span,
	.pagination_primary > li > a:hover,
	.pagination_primary > li > a:focus,
	.dropcap_primary:first-letter,
	.tooltip-1 .tooltip-inner,
	.btn-primary,
	.forms__label-check-1:after,
	.forms__label-radio-2:before,
	.panel-default > .panel-heading,
	.b-isotope-filter > li > a.current:after,
	.b-isotope-filter > li > a:hover:after,
	.owl-theme .owl-controls .owl-page.active span,
	.owl-theme .owl-controls.clickable .owl-page:hover span,
	.b-pricing.active .b-pricing-price,
	.b-team .social-net__item:hover,
	.bx-wrapper .bx-pager.bx-default-pager a:hover,
	.bx-wrapper .bx-pager.bx-default-pager a.active,
	.bx-wrapper .bx-pager.bx-default-pager a:focus {background-color: $main_color;}
	
	
	.border_prim,
	.border_prim_h:hover,
	.pagination > .active > a,
	.pagination > .active > span,
	.pagination a:hover,
	.pagination span:hover,
	.pagination a:focus,
	.pagination span:focus,
	.progress_border_primary,
	.forms__label-radio-2:before,
	.owl-theme_mod-a .owl-controls .owl-page.active span,
	.owl-theme_mod-a .owl-controls.clickable .owl-page:hover span {border-color: $main_color;}
	
	.border-t_prim,
	.border-t_prim_a:after,
	.border-t_prim_b:before,
	.border-t_prim_h:hover,
	.tooltip-1.top .tooltip-arrow,
	.tooltip-1.top-left .tooltip-arrow,
	.tooltip-1.top-right .tooltip-arrow {border-top-color: $main_color;}
	
	.border-r_prim,
	.border-r_prim_h:hover,
	.tooltip-1.right .tooltip-arrow {border-right-color: $main_color;}
	
	.border-b_prim,
	.border-b_prim_h:hover,
	.tooltip-1.bottom .tooltip-arrow,
	.tooltip-1.bottom-left .tooltip-arrow,
	.tooltip-1.bottom-right .tooltip-arrow,
	.table_primary > thead > tr > th,
	.collapse.in {border-bottom-color: $main_color;}
	
	.border-l_prim,
	.border-l_prim_h:hover,
	.tooltip-1.left .tooltip-arrow,
	.border-left_primary:before,
	.b-blockquote-1 {border-left-color: $main_color;}
	.b-taglines__inner:before{ background-color: $main_color;}
	
	.navbar .navbar-nav > li > a { font-family: {$button_font}; }
	a.comment-reply-link{ font-family: {$button_font}; }
	.pagination__title,
	.progress__title ,
	.progress-w-number .progress-bar__number,
	.b-advertisement__label,
	.b-blockquote-3 .b-blockquote__author,
	.b-contact__name,
	.b-events .b-events-calendar,
	.b-events-2 .b-events-calendar,
	.b-info,
	.b-isotope-filter > li > a,
	.b-isotope-grid__title,
	.b-isotope__info,
	.b-post-1 .entry-footer .social-net__title,
	.b-post-1 .entry-footer .post-tags__link,
	.comments-list .comment-author,
	.comments-list .comment-btn,
	.about-author__title,
	.b-progress-list__item,
	.b-request-estimate__title,
	.b-taglines__title,
	.b-title-page__title,
	.footer .footer-section__subtitle,
	.widget-list .widget-list__link,
	.list-tags__link { font-family: {$heading_font}; }

  ";
  wp_add_inline_style( 'ova-dvents-style', $custom_css );
  if( $hide_line ){
  	wp_add_inline_style( 'ova-dvents-style', $hide_line );	
  }
  
  
    
}




/* Google Font */
function dvents_customize_google_fonts() {
    $fonts_url = '';

    $body_font = get_theme_mod('body_font', 'Roboto');
    $heading_font = get_theme_mod('heading_font', 'Raleway');
    $button_font = get_theme_mod('button_font', 'Poppins');

    
    $body_font_c = _x( 'on', $body_font.': on or off', 'ova-dvents');
    $heading_font_c = _x( 'on', $heading_font.': on or off', 'ova-dvents' );
    $button_font_c = _x( 'on', $button_font.': on or off', 'ova-dvents' );

 
    if ( 'off' !== $body_font_c || 'off' !== $heading_font_c || 'off' !== $button_font_c ) {
        $font_families = array();
 
        if ( 'off' !== $body_font_c && strpos($body_font,'ovatheme_') === false ) {
            $font_families[] = $body_font.':100,200,300,400,500,600,700,800,900"';
        }
 
        if ( 'off' !== $heading_font_c  && strpos($heading_font,'ovatheme_') === false ) {
            $font_families[] = $heading_font.':100,200,300,400,500,600,700,800,900';
        }

        if ( 'off' !== $button_font_c  && strpos($button_font,'ovatheme_') === false ) {
            $font_families[] = $button_font.':100,200,300,400,500,600,700,800,900';
        }
        

        if($font_families != null){
          $query_args = array(
              'family' => urlencode( implode( '|', $font_families ) ),
              'subset' => urlencode( 'latin,latin-ext' ),
          );  
          $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
        }
        
 
        
    }
 
    return esc_url_raw( $fonts_url );
}






/************************************************************************************************/
/************************************************************************************************/

function dvents_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);
   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return $rgb; // returns an array with the rgb values
}













