<?php

/* This is functions define blocks to display post */

if ( ! function_exists( 'dvents_content_thumbnail' ) ) {
  function dvents_content_thumbnail( $size ) {
    if ( has_post_thumbnail()  && ! post_password_required() || has_post_format( 'image') )  :
      the_post_thumbnail( $size, array('class'=> 'img-responsive' ));
    endif;
  }
}

if ( ! function_exists( 'dvents_postformat_video' ) ) {
  function dvents_postformat_video( ) { ?>
    <?php if(has_post_format('video') && wp_oembed_get(get_post_meta(get_the_id(), "dvents_met_embed_media", true))){ ?>
	    <div class="js-video postformat_video">
	        <?php echo wp_oembed_get(get_post_meta(get_the_id(), "dvents_met_embed_media", true)); ?>
	    </div>
    <?php } ?>
  <?php }
}

if ( ! function_exists( 'dvents_postformat_audio ') ) {
  function dvents_postformat_audio( ) { ?>
    <?php if(has_post_format('audio') && wp_oembed_get(get_post_meta(get_the_id(), "dvents_met_embed_media", true))){ ?>
	    <div class="js-video postformat_audio">
	        <?php echo wp_oembed_get(get_post_meta(get_the_id(), "dvents_met_embed_media", true)); ?>
	    </div>
    <?php } ?>
  <?php }
}

if ( ! function_exists( 'dvents_content_title' ) ) {
  function dvents_content_title() { ?>

    <?php if ( is_single() ) : ?>
      <h1 class="post-title">
          <?php the_title(); ?>
      </h1>
    <?php else : ?>
      <h2 class="post-title">
        <a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
          <?php the_title(); ?>
        </a>
      </h2>
      <?php endif; ?>

 <?php }
}


if ( ! function_exists( 'dvents_content_meta' ) ) {
  function dvents_content_meta( ) { ?>
	    <span class="post-meta-content">
		    <span class=" post-date">
		        <span class="left"><i class="entry-meta__icon icon-calendar text-primary"></i></span>
		        <span class="right"><?php the_time( get_option( 'date_format' ));?></span>
		    </span>
		    <span class="slash"> </span>
            <?php
            if (has_category()){ ?>
                <span class=" post-author">
                    <span class="left"><i class="entry-meta__icon icon-grid text-primary"></i></span>
                    <span class="right"> <?php the_category(', ') ?></span>
                </span>
            <?php } ?>
		</span>
  <?php }
}

if ( ! function_exists( 'dvents_content_meta_event' ) ) {
	function dvents_content_meta_event( $time_start, $time_end ) {
		$time_start_text = date('F d Y , h A',$time_start);
		$time_end_text = date('F d Y , h A',$time_end);
	    ?>
        <span class="post-meta-content">
		    <span class=" post-date">
		        <span class="left"><i class="entry-meta__icon icon-calendar text-primary"></i></span>
		        <span class="right"><?php echo esc_html($time_start_text) ?></span> -
		        <span class="right"><?php echo esc_html($time_end_text) ?></span>
		    </span>
		    <span class="slash"> </span>
			<?php
			if (has_category()){ ?>
                <span class=" post-author">
                    <span class="left"><i class="entry-meta__icon icon-grid text-primary"></i></span>
                    <span class="right"> <?php the_category(', ') ?></span>
                </span>
			<?php } ?>
		</span>
	<?php }
}


if ( ! function_exists( 'dvents_content_body' ) ) {
  function dvents_content_body( ) { ?>
  	<div class="post-excerpt">
		<?php if(is_single()){
		    the_content();
		    wp_link_pages();                
		}else{
			the_excerpt();
		}?>
	</div>

	<?php 
	}
}

if ( ! function_exists( 'dvents_content_readmore' ) ) {
  function dvents_content_readmore( ) { ?>
      <div class="entry-footer">
          <a href="<?php the_permalink(); ?>" class="btn btn-default btn-xs">
              <div class="icon"></div>
              <?php  esc_html_e('Read more', 'ova-dvents'); ?>
          </a>
          <div class="entry-meta rightcomment">
              <span class="entry-meta__item">
                  <i class="entry-meta__icon icon-speech text-primary"></i>
                  
		            <?php comments_popup_link(
			            esc_html__(' 0 comment', 'ova-dvents'),
			            esc_html__(' 1 comment', 'ova-dvents'),
			            ' % comments'.esc_html__('', 'ova-dvents'),
                  '',
                  esc_html__( 'Comment off', 'ova-dvents' )
		            ); ?>
		        
              </span>
          </div>
      </div>
 <?php }
}

if ( ! function_exists( 'dvents_content_tag' ) ) {
  function dvents_content_tag( ) { ?>
      <div class="entry-footer">
          
              <?php apply_filters('dvents_content_social', 10); ?>
          
          <?php if (has_tag()){ ?>
          <div class="post-tags">
	          <?php the_tags('',', ',''); ?>
          </div>
          <?php } ?>
      </div>
 <?php }
}

if ( ! function_exists( 'dvents_content_gallery' ) ) {
 	function dvents_content_gallery( ) {

		

			$gallery = get_post_meta(get_the_ID(), 'dvents_met_file_list', true)?get_post_meta(get_the_ID(), 'dvents_met_file_list', true):'';

		    $k = 0;
		    if($gallery){
		        $i=0;

		        ?>

		        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
				  <!-- Indicators -->
				  <ol class="carousel-indicators">
				  	<?php foreach ($gallery as $key => $value) { ?>
				    	<li data-target="#carousel-example-generic" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php echo ($i==0) ? 'active':''; ?>"></li>
				    <?php $i++; } ?>
				  </ol>

				  <!-- Wrapper for slides -->
				  <div class="carousel-inner" role="listbox">
				  	<?php foreach ($gallery as $key => $value) { ?>
					    <div class="item <?php echo esc_attr($k==0)?'active':'';$k++; ?>">
					      <img class="img-responsive" src="<?php  echo esc_attr($value); ?>" alt="<?php echo get_the_title(); ?>">
					    </div>
				   	<?php } ?>
				   </div>

				</div>

		       
		        <?php
		    }
		

	}
}






if (!function_exists('dvents_content_author')){
    function dvents_content_author(){
	    $user_info = get_userdata(get_the_author_meta('ID'));
      if( get_the_author_meta('description') != ''){
        ?>
        <article class="about-author bg-grey clearfix">
            <div class="about-author__img"><img src="<?php echo get_avatar_url(get_the_author_meta('ID')) ?>" alt="<?php the_author() ?>" class="img-responsive"></div>
            <div class="about-author__inner">
                <div class="about-author__header"><span class="about-author__title"><?php the_author() ?></span><span class="about-author__category"><?php echo implode(', ',$user_info->roles) ?></span></div>
                <div class="about-author__description"><?php echo get_the_author_meta('description') ?></div>
            </div>
        </article>
 <?php   } }

}

//Custom comment List:
if ( ! function_exists( 'dvents_theme_comment' ) ) {
function dvents_theme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>   
   <li <?php comment_class(' '); ?> id="li-comment-<?php comment_ID() ?>">
     <article class="comment clearfix" id="comment-<?php comment_ID(); ?>">
         <div class="comment-avatar">
         	<?php echo get_avatar($comment,$size='70', $default = 'mysteryman' ); ?>
         </div>

         <div class="comment-inner">
             <header class="comment-header">
                 <cite class="comment-author">
	                 <?php printf('%s', get_comment_author_link()) ?> &nbsp;
                     <?php edit_comment_link( __( '&nbsp;(Edit)', 'ova-dvents' ), '  ', '' );?>
                     <div class="comment-datetime"><?php echo human_time_diff(strtotime($comment->comment_date,time())) ?></div>
	                 <?php
                     $text = esc_html__( 'reply', 'ova-dvents' );
                     comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'],'reply_text' => '<i class="icon icon-action-undo"></i> '.$text)))
                     ?>
                 </cite>
             </header>
            <div class="comment-body">
              <p><?php comment_text() ?></p>
            </div>
          </div>
          <?php if ($comment->comment_approved == '0') : ?>
             <em><?php esc_html_e('Your comment is awaiting moderation.', 'ova-dvents') ?></em>
             <br />
          <?php endif; ?>
     </article>
<?php
}
}








