<?php if (post_password_required()) return; ?>

<div class="container-fluid">
    <div class="row">

        <div class="content_comments">
            <div id="comments" class="comments">

				<?php if(have_comments()){ ?>
                    <h2 class="ui-subtitle-block"><span class="ui-decor-2 bg-primary"></span><?php echo esc_html__( 'COMMENTS', 'ova-dvents' )  ?></h2>
				<?php } ?>

				<?php if (have_comments()) { ?>
                    <ul class="comments-list list-unstyled">
						<?php wp_list_comments('callback=dvents_theme_comment'); ?>
                    </ul>
					<?php
					// Are there comments to navigate through?

					if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
                        <footer class="navigation comment-navigation" role="navigation">
                            <div class="nav_comment_text"><?php esc_html_e( 'Comment navigation', 'ova-dvents' ); ?></div>
                            <div class="previous"><?php previous_comments_link(__('&larr; Older Comments', 'ova-dvents')); ?></div>
                            <div class="next right"><?php next_comments_link(__('Newer Comments &rarr;', 'ova-dvents')); ?></div>
                        </footer><!-- .comment-navigation -->
					<?php endif; // Check for comment navigation ?>

					<?php if (!comments_open() && get_comments_number()) : ?>
                        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'ova-dvents' ); ?></p>
					<?php endif; ?>

				<?php } ?>

				<?php

				$aria_req = ($req ? " aria-required='true'" : '');
				$comment_args = array(
                    'class_form' => 'form-reply ui-form ui-form-1 typography-last-elem',
					'title_reply' => wp_kses('<h2 class="ui-subtitle-block"><span class="ui-decor-2 bg-primary"></span>' . esc_html__( 'Leave a comment', 'ova-dvents' ) . '</h2>', true),
					'fields' => apply_filters('comment_form_default_fields',
                        array(
						'author' =>'<div class="row" >
                                    <div class="col-md-4">
                                        <input type="text" name="author" value="' . esc_attr($commenter['comment_author']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_html__('Name','ova-dvents') .'" />
                                    </div>',
						'email' => '<div class="col-md-4">
                                        <input type="text" name="email" value="' . esc_attr($commenter['comment_author_email']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_html__('Email','ova-dvents') .'" />
                                    </div>',
						'phone' => '<div class="col-md-4">
                                        <input type="text" name="url" value="' . esc_url($commenter['comment_author_url']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_html__('Website','ova-dvents') .'" />
                                    </div>
                              </div>',

					)
                    ),
					'comment_field' => '<div class="row" >
                                            <div class="col-xs-12">                               
                                                <textarea class="form-control" rows="2" name="comment" placeholder="'. esc_html__('Your Comment ...','ova-dvents') .'"></textarea>
                                            </div>
                                        </div>',
					'submit_button' => '<div class="row">
                                            <div class="col-xs-12">
                                              <button class="ui-form__btn btn btn-primary">'. esc_html__('Submit  comment','ova-dvents') .'</button>
                                            </div>
                                        </div>',
					'comment_notes_before' => '',
					'comment_notes_after' => '',
				);
				?>

				<?php global $post; ?>
				<?php if ('open' == $post->comment_status) { ?>
                    <div class="commentform">

						<?php comment_form($comment_args); ?>

                    </div><!-- end commentform -->
				<?php } ?>


            </div><!-- end comments -->
        </div>

    </div>
</div>


